import re


def format_reward(predict_str: str) -> float:
    pattern = r"<think>.*?</think>\s*<answer>.*?</answer>"
    match_result = re.fullmatch(pattern, predict_str, re.DOTALL)

    return 1.0 if match_result else 0.0

def extract_coordinates(text):
    match = re.search(r'<think>.*?</think>\s*<answer>\s*\((\d+),\s*(\d+)\)\s*</answer>', text, re.DOTALL)
    if match:
        return float(match.group(1)), float(match.group(2))
    return None, None

def acc_reward(predict_str: str, ground_truth: tuple) -> float:
    margin = 25
    pred_x, pred_y = extract_coordinates(predict_str)
    gt_x, gt_y = ground_truth
    if pred_x is None or pred_y is None:
        return 0.0
    
    if abs(pred_x - gt_x) <= margin and abs(pred_y - gt_y) <= margin:
        correct = True
    else:
        correct = False
    
    return 1.0 if correct else 0.0

def dist_reward(predict_str: str, ground_truth: tuple) -> float:
    margin = 50
    pred_x, pred_y = extract_coordinates(predict_str)
    gt_x, gt_y = ground_truth
    if pred_x is None or pred_y is None:
        return 0.0
    
    if abs(pred_x - gt_x) <= margin and abs(pred_y - gt_y) <= margin:
        correct = True
        score = (2 * margin - (abs(pred_x - gt_x) + abs(pred_y - gt_y))) / (2 * margin)
    else:
        correct = False
    
    return score if correct else 0.0


def compute_score(predict_str: str, ground_truth: tuple) -> float:
    return 0.1 * dist_reward(predict_str, ground_truth) + 0.9 * acc_reward(predict_str, ground_truth) + 0.1 * format_reward(predict_str)

