# Code for the paper "Domain Knowledge-Aware VAE Learning Based on Exponential Dissimilarity-Dispersion Family"

This directory contains the code of our manuscript "Incorporating Domain Knowledge in VAE Learning via Exponential Dissimilarity-Dispersion Family" (Submission to ICLR 2024).

## Recommended Environments
We developed and tested this code under the following environments:
- 1x GeForce® NVIDIA RTX 2080 Ti
- 32GB RAM
- Ubuntu 22.04.1 LTS
- CUDA 11.8
- Python 3.10.6
- PyTorch 1.12.1

## How to Setup
We recommend to use venv for installation as
```bash
$ sudo apt install python3.10 python3.10-dev python3.10-venv
$ python3.10 -m venv .env
$ . .env/bin/activate
(.env) $ pip install -U pip
(.env) $ pip install -r requirements.txt
```
This command installs some third-party libraries of PyTorch via requirements.txt.

## How to Train
You can train the model with settings in a YAML format:
```bash
(.env) $ python train.py settings/celeba.yaml
```
Some datasets have to be downloaded manually.
Please refer to the YAML files in the `settings` directory to run experiments in your own settings.

A command help is also available via the `--help` option:
```bash
(.env) $ python train.py --help
```

## How to Evaluate
You can evaluate the model with the following command:
```bash
(.env) $ python train.py -np settings/celeba.yaml
```