from common_imports import np

def get_ood_results_with_per_class_thresholds(scores, map_dict, thresholds):
    """
    This function applies the ood detection according to the by-class thresholds.

    scores: The ood scores.
    map_dict: The mapping dictionary for the examples of different classes.
    thresholds: The by-class thresholds.
    """
    # OOD detection with the given thresholds
    ood_result_by_class = {}
    ood_result_total = np.zeros(scores.shape[0])
    for classId in map_dict:
        class_ood_result = np.less(scores[map_dict[classId]], thresholds[classId]).astype(int)
        ood_result_by_class[classId] = class_ood_result
        ood_result_total[map_dict[classId]] = class_ood_result

    return ood_result_total, ood_result_by_class

def evaluate_mult_scores(scores, correct_factors):
    """
    This function combines multiple scores as one single score.

    scores: A list of scores to be combined.
    correct_factors: The list containing the correction factors. (i.e., to adjust the quantity level.)
    """

    return np.sum([correct_factors[index]*scores[index] for index in range(len(scores))], axis=0)

