﻿Code for HFR can be found in the hfr directory, with the relabeling scheme configured in the "relabel_method" parameter in configs/default.py. Code for the Visual-Reacher experiment can be found in the visual_hfr directory. This code is built on top of the open-source PEARL (Rakelly et al., 2019) implementation found here: https://github.com/katerakelly/oyster. Code for the PEARL baseline can be found in the pearl directory. Our code can also be found online at https://anonymous.4open.science/r/hfr_iclr_code-73E3/README.md.

## Installation

### Install MuJoCo

1. Obtain a 30-day free trial or license on the [MuJoCo website](https://www.roboti.us/license.html). You will be emailed a file called `mjkey.txt`.
2. Download the MuJoCo version 1.5 and 2.0 binaries.
3. Unzip the downloaded `mjpro150` directory into `~/.mujoco/mjpro150`, unzip the downloaded `mujoco200` directory into ~/.mujoco/mujoco200
   and place `mjkey.txt` at `~/.mujoco/mjkey.txt`.
4. ``
pip install -U 'mujoco-py<1.50.2,>=1.50.1'
`` for MuJoCo version 1.5 or ``pip install -U 'mujoco-py<2.1,>=2.0'`` for MuJoCo version 2.0
MuJoCo version 2.0 was used for the Sawyer environments, while version 1.5 was used for the other environments.

### Install Meta-World
We use Meta-World for the Sawyer environments. Meta-World can be installed with the following:
```
git clone https://github.com/rlworkgroup/metaworld.git
git checkout 2f228c2
cd metaworld
pip install -e .
```
### Install everything else

``
pip install -r requirements.txt
``

This code was tested using Python version 3.6.8.

## Usage
To run the PEARL baseline, cd to the pearl directory. To run HFR or any of the relabeling baselines, cd to the hfr directory and change "relabel_method" parameter to the desired relabeling scheme in configs/default.py. Then run the following:
``
python launch_experiment.py <config file>
``
The output directory can be configured with the "base_log_dir" parameter in configs/default.py.

### Example: Running Ant-Goal
``
python launch_experiment.py ./configs/ant-goal.json
``
