# ![YouCLIP Logo](./assets/YouCLIP_logo.png "Logo")



# 项目简介

CLIP (Contrastive Language-Image Pre-training)通过对比学习来匹配图像和文本，其在图文跨模态检索，图搜图，文生图等众多下游任务有广泛的应用，是众多跨模态任务的基石模型。
而目前针对中文的CLIP，其训练的数据量和性能相比于英文CLIP来说，总体偏低，例如CN-CLIP，其在2亿图文对上训练得到；
相比于英文CLIP动辄上百亿的高质量数据相比，目前已有的中文CLIP还有很大的提升空间。
而本项目通过3个阶段的训练，以最强英文CLIP为起点，在数十亿的数据上微调得到了目前最强的中文CLIP模型，且其不仅仅支持中文，还可以同时支持中英双语，且性能大大超越CNCLIP，成为目前最强的中文CLIP模型。

本项目旨在提供：

1. **目前业界最强的中文CLIP模型。**
2. **同时支持中文和英文的双语CLIP模型。**
3. **不同模型大小，不同的embedding维度的最强中文CLIP模型，以适应不同的业务需求。**

# 模型介绍

本仓库中，包含以下几个模型，其与WeCLIP的对比如下：

|        Model Zoo         | Chkpt |   总参数量   | 计算量GFLOPs | embedding dim | 语言    | 分辨率 | 文本Token长度 |
|:------------------------:|:-----:|:--------:|:-----------:|:---------------:|:-------:|:-----:|:-----------:|
|         **Base**         |       |          |           |               |       |     |           |
|       WeCLIP-Base        |       |   204M   | 47.6      | 1024          | 仅中文   | 224 | 72        |
|       YouCLIP-Base       |       |   209M   | 47.1      | 768           | 仅中文   | 224 | 77        |
|   YouCLIP-Base-CN-ENG    |       |   209M   | 47.1      | 768           | 中文+英文 | 224 | 77        |
|     YouCLIP-Base-512     |       |   210M   | 190.6     | 768           | 仅中文   | 512 | 77        |
| YouCLIP-Base-512-CN-ENG  |       |   210M   | 190.6     | 768           | 中文+英文 | 512 | 77        |
|        **Large**         |       |          |           |               |       |     |           |
|       WeCLIP-Large       |       |   600M   | 198.7     | 1024          | 仅中文   | 224 | 72        |
|      YouCLIP-Large       |       |   660M   | 194.8     | 1024          | 仅中文   | 256 | 64        |
|   YouCLIP-Large-CN-ENG   |       |   660M   | 194.8     | 1024          | 中文+英文 | 256 | 64        |
|         **Huge**         |       |          |           |               |       |     |           |
|       WeCLIP-Huge        |       |  1192M   | 367.8     | 1024          | 仅中文   | 224 | 72        |
|       YouCLIP-Huge       |       |  1016M   | 656.8     | 1152          | 仅中文   | 384 | 64        |
|   YouCLIP-Huge-CN-ENG    |       |  1016M   | 656.8     | 1152          | 中文+英文 | 384 | 64        |


上述表格中，后缀带`CN-ENG`为`中英双语`模型，不带该后缀的为`纯中文`模型。`中英双语`模型和`纯中文`模型相比，其中文能力有所下降，但是增加了对英文的支持。




# 测评结果

我们遵循WeCLIP的测评数据集和指标, 在多个 zero-shot 测试集上进行了测试，包括：
* 图文检索类测试集：MUGE、Flickr-CN、COCO-CN
* 图片零样本分类测试集：elevater 系列（20个数据集）

在此处列出主要的结果，以下表格的检索指标均为R@1下的指标，英文能力使用ImageNet-1K Top1 Accuracy来评估，Elevater的指标为20个数据集的平均值：

|            Model            | COCO T2I | COCO I2T | Flickr T2I | Flickr I2T | MUGE T2I | MUGE I2T | Elevater  | 英文能力 (ImageNet-1K Top1) |
|:---------------------------:|:--------:|:--------:|:----------:|:----------:|:--------:|:--------:|:---------:|:-----------------------:|
|           _Base_            |          |          |            |            |          |          |           |                         |
|        CN-CLIP-Base         |   62.2   |   56.3   |    62.7    |    74.6    |   52.1   |   38.7   |   53.5    |          ----           |
|        QA-CLIP-Base         |   62.9   |   61.5   |    63.8    |    78.4    |   53.2   |   40.7   |     -     |          ----           | 
|  **YouCLIP-Base-CN-ENG**    | **68.2** | **70.1** |  **71.0**  |  **88.9**  | **57.0** | **48.4** | **59.3**  |        **71.52**        |
|      **YouCLIP-Base**       | **67.4** | **70.5** |  **71.8**  |  **88.7**  | **61.9** | **53.2** | **61.17** |          ----           |
|           _Large_           |          |          |            |            |          |          |           |                         |
|        CN-CLIP-Large        |   64.9   |   60.6   |    68.0    |    80.2    |   56.4   |   42.6   |   60.0    |          ----           |
|        QA-CLIP-Large        |   65.7   |   64.5   |    69.3    |    85.3    |   57.4   |   45.5   |     -     |          ----           |
| **YouCLIP-Base-512-CN-ENG** | **69.1** | **70.7** |  **77.7**  |  **92.8**  | **61.8** | **53.8** | **62.6**  |        **75.18**        | 
|    **YouCLIP-Base-512**     | **69.0** | **72.5** |  **77.3**  |  **93.5**  | **61.0** | **52.4** | **60.4**  |          ----           |
|  **YouCLIP-Large-CN-ENG**   | **70.1** | **73.1** |  **76.8**  |  **90.8**  | **62.3** | **54.1** | **63.6**  |        **76.9**         |
|      **YouCLIP-Large**      | **70.7** | **73.1** |  **77.2**  |  **92.1**  | **64.7** | **56.3** | **64.1**  |          ----           |
|           _Huge_            |          |          |            |            |          |          |           |                         | 
|        CN-CLIP-Huge         |   68.3   |   59.3   |    71.6    |    79.5    |   63.1   |   49.4   |   61.1    |          ----           |  
|   **YouCLIP-Huge-CN-ENG**   |   **71.2**   |   **72.0**   |    **81.3**    |    **95.2**    |   **66.5**   |   **58.1**   |   **66.5**    |          **80.9**           | 
|      **YouCLIP-Huge**       | **71.9** | **73.1** |  **82.1**  |  **95.9**  | **68.0** | **58.6** | **65.9**  |          ----           |  


注：`YouCLIP-Base-512`的模型由于其图像分辨率很高，因此，其无论是总计算量(GFLOPs)，推理时间(QPS)，还是显存占用，都和`Large版本`模型接近。因此我们将归为`Large版本`进行对比。




# 安装与运行

## 环境配置
本项目基于 pytorch 开发，请先根据 [pytorch 官方网站](https://pytorch.org/get-started/locally/)的指引，安装 pytorch和torchvision。本项目要求 pytorch版本 >= 1.9.0 即可。 
```bash
 pip install torch torchvision 
 ```

安装完 pytorch 之后，然后 cd 到本项目根目录，安装本项目，此处我们推荐使用如下开发模式进行安装：

```bash
pip install -e .
```
注意，上述命令最后有一个点 "." 不能遗漏, 其表示根据当前目录的setup.py文件执行安装。该命令会自动安装[requirements.txt](requirements.txt)中所需的包。
本项目基于[open-clip](https://github.com/mlfoundations/open_clip)开源项目进行构建，因此，上述安装过程也类似。


# 快速运行
以下代码片段展示了如何使用本项目的 YouCLIP 进行图片的零样本分类。
```python
from open_clip import load_YouCLIP
import torch
from PIL import Image

# model_file_path 参数传入下载的模型权重的路径， model_name为上述表格中的模型名称
model, preprocess, tokenizer = load_YouCLIP(model_name='YouCLIP-Base',
                                            model_file_path='/xxx/YouCLIP-Base.pt')

# 读取图片，并使用preprocess进行预处理
image = preprocess(Image.open("assets/demo.png")).unsqueeze(0)

# 零样本分类的类别名称
text = tokenizer(["一只猪", "一个狗", "一只猫"])

with torch.no_grad(), torch.cuda.amp.autocast():
    # 提取图片特征
    image_features = model.encode_image(image)
    # 提取类别文本特征
    text_features = model.encode_text(text)
    # 特征归一化
    image_features /= image_features.norm(dim=-1, keepdim=True)
    text_features /= text_features.norm(dim=-1, keepdim=True)
    # 计算相似度
    text_probs = (100.0 * image_features @ text_features.T).softmax(dim=-1)
print(text_probs)
```
上述代码将输出图片在每个类别的概率分布：
```text
tensor([[7.6329e-04, 6.1830e-04, 9.9862e-01]])
```
