## Implementation of Theory-Inspired Contrastive Learning with Self-Supervised Label Refinement


### Requirements:
* CIFAR10 dataset
* Python = 3.6
* PyTorch = 1.2
* pip install tqdm

### Self-supervised Training:
To pretrain a ResNet-50 model on CIFAR10, please run
<pre>python main_moco.py \ 
  -a resnet50 \ 
  --lr 0.03 \
  --batch-size 256 \
  --epochs 2000 \
  --temperature 0.2 \
  --teacher_weight 0.5 \
  --teach_T 0.2 \
  --t 0.2 \
  --lam 2.0 \
  --data-path [CIFAR10 dataset path]
</pre>
This training takes about 6 days on single V100 GPU. Here we only provide CLEAN using strong augmentations. If you want to run CLEAN with weak augmentations, please directly replace the augmentation.

### Linear Evaluation
To train a linear  classifier on CIFAR10, please load the pretrained model in the "pretrained_models" which is CLEAN using strong augmentations, and then run:
<pre>python main_linear.py --pretrained [your pretrained model] \
  -a resnet50 \ 
  --lr 0.01 \
  --batch-size 256 \
  --epochs 200 \
  --data-path [CIFAR10 dataset path]
</pre>
This training takes about 1.5 hours on single V100 GPU. After training, you should obtain the following results:

Model| linear evaluation | KNN
 --- | --- | --- 
CLEAN| 96.5| 95.5 

### KNN Evaluation
To test the pretrained model in the "pretrained_models" which is CLEAN using strong augmentations, you can directly run:
<pre>python main_knn.py --pretrained [your pretrained model] \
  -a resnet50 \ 
  --knn-t 0.05 \
  --knn-k 200 \
  --data-path [CIFAR10 dataset path]
</pre>

You should get the above results in the Table.  

## Pretraining and Evalutation on ImageNet
Due to time and effort limitation, we will clean up the code and release all codes and models online. 


