## Implementation of Theory-Inspired Contrastive Learning with Self-Supervised Label Refinement

## Pretraining and Evalutation on ImageNet
### Requirements:
* Imagenet dataset
* Python = 3.6
* PyTorch = 1.7
* at least 8 A100

### Self-supervised Training:
We give some examples for training on Imagenet. To pretrain a ResNet-50 model on Imagenet for CLEAN-Single under weak augmentation, please run
<pre>python main.py \ 
  -a resnet50 \ 
  --lr 0.03 \
  --batch-size 256 \
  --epochs 200 \
  --temperature 0.2 \
  --teacher_weight 0.5 \
  --teach_t 0.2 \
  --moco-t 0.2 \
  --strong_crop_num 0 \
  --weak_crop_num 1 \
  --crop_size 96 \
  --lam 0.1 \
  --dist-url 'tcp://localhost:10001' --multiprocessing-distributed --world-size 1 --rank 0 \
  --data-path [ImageNet dataset path]
</pre>
This training takes about 77 hours on 8 GPU. For strong augmentations, you can set strong_crop_num=1, weak_crop_num=0.

### Linear Evaluation
To train a linear  classifier on Imagenet, please load the pretrained model in the "pretrained_models" which is CLEAN-single under 200 epochs with weak augmentations, and then run:
<pre>python main_linear.py --pretrained [your pretrained model] \
  -a resnet50 \ 
  --lr 30 \
  --batch-size 256 \
  --epochs 100 \
  --data-path [Imagenet dataset path]
</pre>
This training takes about 11 hours on 8 GPUs. After training, you should obtain the following results:

Model| linear evaluation  
 -------------- | --------------- |  
CLEAN-Single (weak)| 70.6|  