#!/usr/bin/env bash
set -e

# parameters
algorithms="alg1,alg2,alg3,alg4,alg5"
T=2000
batch_size=50
d=20  # not used
K=5
num_runs=10
S=1
kappa=10
nu="0.1 0.1 0.1 1.0 1.0"
lambda_reg="0.1 0.1 0.1 1.0 1.0"

for latent in mnist mushroom shuttle; do
  output_dir="results/figures_${latent}"
  mkdir -p "$output_dir"

  for cnum in 500; do
    # generate data
    python generate_figures_real.py \
      --algorithms "$algorithms" \
      --latent_function "$latent" \
      --T "$T" \
      --batch_size "$batch_size" \
      --d "$d" \
      --K "$K" \
      --num_runs "$num_runs" \
      --output_dir "$output_dir" \
      --S "$S" \
      --kappa "$kappa" \
      --nu $nu \
      --lambda_reg $lambda_reg \
      --cnum "$cnum"

    # find np file
    npz_file=( "$output_dir"/regret_data_*"_lat${latent}_cnum${cnum}"*.npz )
    # redraw
    python redraw_plot.py \
      --npz_file "${npz_file[0]}" \
      --output "subfigure_${latent}_${cnum}.png"
  done
done