## Environment setup

This project uses a Conda environment to manage dependencies. The `environment.yml` defines the Conda environment:

```yaml
name: nlb
channels:
  - defaults
  - https://repo.anaconda.com/pkgs/main
  - https://repo.anaconda.com/pkgs/r
dependencies:
  - pip=25.0
  - python=3.9.21
  - pip:
      - matplotlib==3.9.4
      - numpy==1.26.3
      - pandas==2.2.3
      - scikit-learn==1.6.1
      - scipy==1.13.1
      - torch==2.6.0
      - torchaudio==2.6.0
      - torchvision==0.21.0
      - tqdm==4.67.1
```

```bash
conda env create -f environment.yml
conda activate nlb
```


## Usage Examples

* **Run experiments for Figures 1 and 3**:

  ```bash
  ./run_fig_1_3.sh
  ```
* **Run experiments for Figure 2**:

  ```bash
  ./run_fig_2.sh
  ```

