clear;
seed =42;
rng(seed);
load('wikivital_mathematics.mat');
[m,n]= size(A);
idx=randperm(m);
m = 400;
A = A(idx(1:m),:);
b = b(idx(1:m),:);

epsilon_f = 1e-6;
epsilon_g = 1e-6;
D=2;
maxiter = 4e4;
maxT = 20;

%% function definition
fun_g = @(x) sum_square(A*x-b)/2;
ATA = A'*A; Ab = A'*b;
grad_g = @(x) ATA * x - Ab;
fun_f= @(x) 1/2*sum_square(x);
grad_f= @(x) x;
 
Lf = 1;
Lg = eigs(A'*A,1);

T = [A,zeros(m,m);eye(n),A'];
Tx = T\[b;zeros(n,1)];
xstar = Tx(1:n);
gstar = 0; fstar = fun_f(xstar);
x0 = rand(n,1); x0 = x0 / norm(x0,2);

%% FCB-BiO-smooth algorithm
param.epsilonf = epsilon_f;
param.epsilong = epsilon_g;
param.D = D; 
param.Lf = Lf;
param.Lg = Lg;
param.maxiter = maxiter;

disp('FCB-BiO-smooth starts')
[f_vec1,g_vec1,time_vec1,x1,vec_t_smooth,vec_t_time_smooth] = FCB_BiO_smooth(fun_f,grad_f,grad_g,fun_g,param,x0); 
disp('FCB-BiO-smooth Achieved!')

%% FCB-BiO-Lipschitz algorithm
param.epsilonf = 0.001;
param.epsilong = 0.001;
param.maxiter = maxiter*2;
param.eta = 0.0003;
param.D = D;

disp('FCB-BiO-Lipschitz starts')
[f_vec2,g_vec2,time_vec2,x2,vec_t_ns,vec_t_time_Lipschitz] = FCB_BiO_Lipschitz(fun_f,grad_f,grad_g,fun_g,param,x0); 
disp('FCB-BiO-Lipschitz Achieved!')

%% AGM-BiO algorithm
param.epsilonf = epsilon_f;
param.epsilong = epsilon_g;
param.maxiter = maxiter/2;
param.maxT = maxT;
param.Lf = Lf;
param.Lg = Lg;
param.D = D;
% param.gamma = 1/(2*(Lg/Lf)*maxiter^(2/3)+2); % worse than 1.
param.gamma = 1;
disp('AGM-BiO starts');
[f_vec3,g_vec3,time_vec3,x3] = AGM_BiO(fun_f,grad_f,grad_g,fun_g,param,x0);
disp('AGM-BiO Achieved!');
% 
%% PB-APG algrotihm
param.epsilonf = epsilon_f;
param.epsilong = epsilon_g;
param.Lf = Lf;
param.Lg = Lg;
param.maxiter = maxiter;
param.gamma = 1e5;
param.T = maxT;
param.D = D;
disp('PB-APG starts');
[f_vec4,g_vec4,time_vec4,x4] = PB_APG(fun_f,grad_f,grad_g,fun_g,param,x0);
disp('PB-APG Achieved!');

%% Bi-SG algorithm
param.epsilonf = epsilon_f;
param.epsilong = epsilon_g;
param.maxiter = maxiter;
param.maxT = maxT;
param.Lf = Lf;
param.Lg = Lg;
param.D = D;
disp('Bi-SG starts');
[f_vec5,g_vec5,time_vec5,x5] = Bi_SG(fun_f,grad_f,grad_g,fun_g,param,x0);
disp('Bi-SG Achieved!');

%% a-IRG Algorithm
param.maxiter=maxiter;
param.Lf = Lf;
param.Lg = Lg;
param.maxT = maxT;
param.D = D;

disp('a-IRG Algorithm starts')
[f_vec6,g_vec6,time_vec6,x6] = Alg_Projection(fun_f,grad_f,grad_g,fun_g,param,x0);
disp('a-IRG Solution Achieved!');

%% CG-BiO algorithm
param.epsilonf = epsilon_f;
param.epsilong = epsilon_g;
param.maxiter=maxiter;
param.maxT = maxT;
param.maxiter0 = 1000;
param.D = D;

disp('CG-BiO starts');
[f_vec7,g_vec7,time_vec7,x7] = CG_BiO(fun_f,grad_f,grad_g,fun_g,param,x0);
disp('CG-BiO Achieved!');

%% Bisec-BiO algrotihm
param.epsilonf = epsilon_f;
param.epsilong = epsilon_g;
param.Lf = Lf;
param.Lg = Lg;
param.maxiter = maxiter;
param.T = maxT;
param.D = D;
disp('Bisec-BiO starts');
[f_vec8,g_vec8,time_vec8,x8,vec_t_bisec,vec_t_time_bisec] = Bisec_BiO(fun_f,grad_f,grad_g,fun_g,param,x0);
disp('Bisec-BiO Achieved!');
save('result.mat');