function [f_vec,g_vec,time_vec,x,vec_t,vec_t_time] = FCB_BiO_smooth(fun_f,grad_f,grad_g,fun_g,param,x0)

epsilon_f= param.epsilonf/2;
epsilon_g= param.epsilong/2;
epsilon = max(epsilon_f,epsilon_g);
maxiter = param.maxiter;
D = param.D;
n = length(x0); 
Lf = param.Lf;
Lg = param.Lg;
eta = max(Lf,Lg);

tic;
iter = 0; 
f_vec = [];
g_vec = [];
time_vec = [];
vec_t = [];
vec_t_time = [];

%% Compute g_k, using accelerated method
x = x0; y = x0;
f_vec = [f_vec;fun_f(x)];
g_vec = [g_vec;fun_g(x)]; 
time_vec = [time_vec;iter];
gstar = realmax;
tt = 1;
for k = 1: 1500
    tmpx = y - 1/Lg*grad_g(y);
    tmpt = 0.5 + sqrt(0.25+tt^2);
    y = tmpx + (tt-1)*(tmpx-x)/tmpt;
    x = tmpx;
    tt = tmpt;
    g_x = fun_g(x);
    gstar = min(gstar,g_x);
    f_vec = [f_vec;fun_f(x)];
    g_vec = [g_vec;g_x];
    time_vec = [time_vec;toc];
end
xstar_g = x;
fun_g = @(x) fun_g(x)-gstar; 

%% Main Algorithm
x = xstar_g; y = xstar_g;
L = 0; R = fun_f(xstar_g);
T = 500;
while iter <= maxiter
    t = (L+R)/2;
    vec_t = [vec_t;t];
    vec_t_time = [vec_t_time;iter];
    lstiter = iter;
    min_ft = realmax;
    
    tt = 1; 
    while iter -lstiter <= T && iter <= maxiter
        iter = iter + 1;
        f_y = fun_f(y); g_y = fun_g(y);
        grad_f_y =  grad_f(y); grad_g_y = grad_g(y);
        tmpx = gradient_mapping(D,t,y,eta,f_y,g_y,grad_f_y,grad_g_y);
        tmpt = 0.5 + sqrt(0.25+tt^2);
        y = tmpx + (tt-1)*(tmpx-x)/tmpt;
        x = tmpx;
        tt = tmpt;

        f_vec = [f_vec;f_y];
        g_vec = [g_vec;g_y+gstar];
        time_vec = [time_vec;toc];
        min_ft = min(min_ft, max(f_y-t,g_y));
        if min_ft<=epsilon
            break;
        end
    end
    if min_ft<=epsilon
        R = t;
    else 
        L = t;
    end
end
x = x;
end
