# change path if needed
LIST=`ls $search_dir`
if echo ${LIST[*]} | grep -qw "main.py"; then
    echo "found"
else
    echo "cd .."
    cd ..
    LIST=`ls $search_dir`
    if echo ${LIST[*]} | grep -qw "main.py"; then
        echo "found"
    else
        echo "not found"
        exit 1
    fi
fi
# activate env
source ./myenv/bin/activate
# param
env="mdp_5s5a_hard"
# run
python3 main.py --log_root ./logs \
                --fname $env \
                --gamma 0.9 \
                --APG_epoch_size 100000000 \
                --APG_graphing_size 1000000 \
                --PG_epoch_size 100000000 \
                --PG_graphing_size 1000000 \
                --PG_adam_epoch_size 100000000 \
                --PG_adam_graphing_size 1000000 \
                --PG_heavy_ball_epoch_size 100000000 \
                --PG_heavy_ball_graphing_size 1000000 \
                --env ./mdp_env/$env.yaml --run_algos PG_heavy_ball PG_adam
# graph
python3 graph.py --log_dir ./logs/$env \
                --plot_LogLog \
                --graphing_size 100000000
# python3 graph.py --log_dir ./logs/$env \
#                 --plot_Value \
#                 --algo APG \
#                 --graphing_size 200000
# python3 graph.py --log_dir ./logs/$env \
#                 --plot_Value \
#                 --algo PG \
#                 --graphing_size 50000000
# python3 graph.py --log_dir ./logs/$env \
#                 --algo APG \
#                 --plot_MomGrad \
#                 --graphing_size 6000