(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 12.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     46601,       1170]
NotebookOptionsPosition[     44751,       1137]
NotebookOutlinePosition[     45149,       1153]
CellTagsIndexPosition[     45106,       1150]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", "Utilities", " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"colMultiply", "[", 
      RowBox[{"m_", ",", "v_"}], "]"}], ":=", 
     RowBox[{
      RowBox[{
       RowBox[{"v", "#"}], "&"}], "/@", "m"}]}], ";"}], "\[IndentingNewLine]",
    "\[IndentingNewLine]", 
   RowBox[{"(*", " ", "Setup", " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"simid", "=", "\"\<TEST\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"directory", "=", "\"\</\>\""}], ";", " ", 
    RowBox[{"(*", " ", 
     RowBox[{
     "set", " ", "this", " ", "directory", " ", "for", " ", "output"}], " ", 
     "*)"}], " ", "\[IndentingNewLine]", 
    RowBox[{"logfile", "=", 
     RowBox[{"directory", "<>", "simid", "<>", "\"\<_START.txt\>\""}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Export", "[", 
     RowBox[{"logfile", ",", "\"\<initializing\>\""}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"ClearAll", "[", 
     RowBox[{
     "prior", ",", "prior0", ",", "ReLU", ",", "f", ",", "f0", ",", "error", 
      ",", "error0", ",", "p", ",", "p0", ",", "nll"}], "]"}], ";", " ", 
    RowBox[{"(*", " ", 
     RowBox[{"Clear", " ", "out", " ", "previous", " ", "definitions"}], " ", 
     "*)"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"(*", " ", 
     RowBox[{"Define", " ", "various", " ", "parameter", " ", "grids"}], " ", 
     "*)"}], "\[IndentingNewLine]", 
    RowBox[{"ngrid", "=", "10"}], ";"}], " ", "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"minbound", "=", "0"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"maxbound", "=", "1"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"dx", "=", 
     RowBox[{"1", "/", "ngrid"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"dy", "=", 
     RowBox[{"1", "/", "ngrid"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"dz", "=", 
     RowBox[{"1", "/", "ngrid"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"grid", "=", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"minbound", "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"maxbound", "-", "minbound"}], ")"}], "*", "dx", " ", 
           "i"}]}], ",", 
         RowBox[{"minbound", "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"maxbound", "-", "minbound"}], ")"}], "*", "dy", " ", 
           "j"}]}], ",", 
         RowBox[{"minbound", "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"maxbound", "-", "minbound"}], ")"}], "*", "dz", " ", 
           "k"}]}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "0", ",", 
         RowBox[{"1", "/", "dx"}], ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"j", ",", "0", ",", 
         RowBox[{"1", "/", "dy"}], ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"k", ",", "0", ",", 
         RowBox[{"1", "/", "dy"}], ",", "1"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"grid", "=", 
     RowBox[{"Flatten", "[", 
      RowBox[{"grid", ",", "2"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"grid", "=", 
     RowBox[{"N", "@", 
      RowBox[{"Select", "[", 
       RowBox[{"grid", ",", 
        RowBox[{
         RowBox[{
          RowBox[{"Total", "[", "#", "]"}], "==", "1"}], "&"}]}], "]"}]}]}], 
    ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"minbound", "=", 
     RowBox[{"-", "1"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"maxbound", "=", "1"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"dx", "=", 
     RowBox[{"1", "/", "ngrid"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"dy", "=", 
     RowBox[{"1", "/", "ngrid"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"dz", "=", 
     RowBox[{"1", "/", "ngrid"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"grid", "=", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"minbound", "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"maxbound", "-", "minbound"}], ")"}], "*", "dx", " ", 
           "i"}]}], ",", 
         RowBox[{"minbound", "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"maxbound", "-", "minbound"}], ")"}], "*", "dy", " ", 
           "j"}]}], ",", 
         RowBox[{"minbound", "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"maxbound", "-", "minbound"}], ")"}], "*", "dz", " ", 
           "k"}]}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "0", ",", 
         RowBox[{"1", "/", "dx"}], ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"j", ",", "0", ",", 
         RowBox[{"1", "/", "dy"}], ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"k", ",", "0", ",", 
         RowBox[{"1", "/", "dy"}], ",", "1"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"grid", "=", 
     RowBox[{"Flatten", "[", 
      RowBox[{"grid", ",", "2"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"minbound", "=", 
     RowBox[{"-", "2"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"maxbound", "=", "2"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"dx", "=", 
     RowBox[{"1", "/", "ngrid"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"dy", "=", 
     RowBox[{"1", "/", "ngrid"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"grid", "=", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"minbound", "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"maxbound", "-", "minbound"}], ")"}], "*", "dx", " ", 
           "i"}]}], ",", 
         RowBox[{"minbound", "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"maxbound", "-", "minbound"}], ")"}], "*", "dy", " ", 
           "j"}]}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "0", ",", 
         RowBox[{"1", "/", "dx"}], ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"j", ",", "0", ",", 
         RowBox[{"1", "/", "dy"}], ",", "1"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"grid", "=", 
     RowBox[{"Flatten", "[", 
      RowBox[{"grid", ",", "1"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"minbound", "=", 
     RowBox[{"-", "1"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"maxbound", "=", "1"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"dx", "=", 
     RowBox[{"1", "/", "ngrid"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"dy", "=", 
     RowBox[{"1", "/", "ngrid"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"dz", "=", 
     RowBox[{"1", "/", "ngrid"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"du", "=", 
     RowBox[{"1", "/", "ngrid"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"grid", "=", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"minbound", "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"maxbound", "-", "minbound"}], ")"}], "*", "dx", " ", 
           "i"}]}], ",", 
         RowBox[{"minbound", "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"maxbound", "-", "minbound"}], ")"}], "*", "dy", " ", 
           "j"}]}], ",", 
         RowBox[{"minbound", "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"maxbound", "-", "minbound"}], ")"}], "*", "dz", " ", 
           "k"}]}], ",", 
         RowBox[{"minbound", "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"maxbound", "-", "minbound"}], ")"}], "*", "du", " ", 
           "l"}]}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "0", ",", 
         RowBox[{"1", "/", "dx"}], ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"j", ",", "0", ",", 
         RowBox[{"1", "/", "dy"}], ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"k", ",", "0", ",", 
         RowBox[{"1", "/", "dz"}], ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"l", ",", "0", ",", 
         RowBox[{"1", "/", "du"}], ",", "1"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"grid", "=", 
     RowBox[{"Flatten", "[", 
      RowBox[{"grid", ",", "3"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Generative", " ", "model", " ", "parameters"}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"lambdas0", "=", 
     RowBox[{"RandomChoice", "@", "gridLAMBDAs"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"mus0", "=", 
     RowBox[{"RandomChoice", "@", "gridMUs"}]}], ";", 
    RowBox[{"While", "[", 
     RowBox[{
      RowBox[{"Not", "[", 
       RowBox[{"DuplicateFreeQ", "@", "mus0"}], "]"}], ",", 
      RowBox[{"mus0", "=", 
       RowBox[{"RandomChoice", "@", "gridMUs"}]}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"alphas0", "=", 
     RowBox[{"RandomChoice", "@", "gridALPHAs"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"neurons0", "=", 
     RowBox[{"RandomChoice", "@", "gridNEURONs"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"\[Lambda]10", "=", 
     RowBox[{"lambdas0", "[", 
      RowBox[{"[", "1", "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"\[Lambda]20", "=", 
     RowBox[{"lambdas0", "[", 
      RowBox[{"[", "2", "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"\[Lambda]30", "=", 
     RowBox[{"lambdas0", "[", 
      RowBox[{"[", "3", "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"\[Mu]10", "=", 
     RowBox[{"mus0", "[", 
      RowBox[{"[", "1", "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"\[Mu]20", "=", 
     RowBox[{"mus0", "[", 
      RowBox[{"[", "2", "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"\[Mu]30", "=", 
     RowBox[{"mus0", "[", 
      RowBox[{"[", "3", "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"\[Alpha]10", "=", 
     RowBox[{"alphas0", "[", 
      RowBox[{"[", "1", "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"\[Alpha]20", "=", 
     RowBox[{"alphas0", "[", 
      RowBox[{"[", "2", "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"\[Beta]10", "=", 
     RowBox[{"neurons0", "[", 
      RowBox[{"[", "1", "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"\[Beta]20", "=", 
     RowBox[{"neurons0", "[", 
      RowBox[{"[", "2", "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"\[Pi]10", "=", 
     RowBox[{"neurons0", "[", 
      RowBox[{"[", "3", "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"\[Pi]20", "=", 
     RowBox[{"neurons0", "[", 
      RowBox[{"[", "4", "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"\[Sigma]0", "=", "0.5"}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Write", " ", "params", " ", "to", " ", "file"}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Export", "[", 
     RowBox[{
      RowBox[{"directory", "<>", "simid", "<>", "\"\<_PARAMS.txt\>\""}], ",", 
      
      RowBox[{"{", 
       RowBox[{"lambdas0", ",", "mus0", ",", "alphas0", ",", "neurons0"}], 
       "}"}]}], "]"}], ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"prior", "[", 
      RowBox[{
      "z_", ",", "\[Lambda]1_", ",", "\[Lambda]2_", ",", "\[Lambda]3_", ",", 
       "\[Mu]1_", ",", "\[Mu]2_", ",", "\[Mu]3_"}], "]"}], " ", ":=", " ", 
     RowBox[{
      RowBox[{"\[Lambda]1", "*", 
       RowBox[{"PDF", "[", 
        RowBox[{
         RowBox[{"NormalDistribution", "[", 
          RowBox[{"\[Mu]1", ",", "1"}], "]"}], ",", "z"}], "]"}]}], "+", 
      RowBox[{"\[Lambda]2", "*", 
       RowBox[{"PDF", "[", 
        RowBox[{
         RowBox[{"NormalDistribution", "[", 
          RowBox[{"\[Mu]2", ",", "1"}], "]"}], ",", "z"}], "]"}]}], "+", 
      RowBox[{"\[Lambda]3", "*", 
       RowBox[{"PDF", "[", 
        RowBox[{
         RowBox[{"NormalDistribution", "[", 
          RowBox[{"\[Mu]3", ",", "1"}], "]"}], ",", "z"}], "]"}]}]}]}], ";"}],
    "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"prior0", "[", "z_", "]"}], " ", ":=", " ", 
     RowBox[{"prior", "[", 
      RowBox[{
      "z", ",", "\[Lambda]10", ",", "\[Lambda]20", ",", "\[Lambda]30", ",", 
       "\[Mu]10", ",", "\[Mu]20", ",", "\[Mu]30"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"ReLU", "[", "x_", "]"}], ":=", 
     RowBox[{"Max", "[", 
      RowBox[{"0", ",", "x"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"f", "[", 
      RowBox[{
      "z_", ",", "\[Alpha]1_", ",", "\[Alpha]2_", ",", "\[Beta]1_", ",", 
       "\[Beta]2_", ",", "\[Pi]1_", ",", "\[Pi]2_"}], "]"}], ":=", 
     RowBox[{
      RowBox[{"\[Alpha]1", "*", 
       RowBox[{"ReLU", "[", 
        RowBox[{
         RowBox[{"\[Beta]1", "*", "z"}], "+", "\[Pi]1"}], "]"}]}], "+", 
      RowBox[{"\[Alpha]2", "*", 
       RowBox[{"ReLU", "[", 
        RowBox[{
         RowBox[{"\[Beta]2", "*", "z"}], "+", "\[Pi]2"}], "]"}]}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"f0", "[", "z_", "]"}], ":=", 
     RowBox[{"f", "[", 
      RowBox[{
      "z", ",", "\[Alpha]10", ",", "\[Alpha]20", ",", "\[Beta]10", ",", 
       "\[Beta]20", ",", "\[Pi]10", ",", "\[Pi]20"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"error", "[", 
      RowBox[{"z_", ",", "\[Sigma]_"}], "]"}], ":=", 
     RowBox[{"PDF", "[", 
      RowBox[{
       RowBox[{"NormalDistribution", "[", 
        RowBox[{"0", ",", "\[Sigma]"}], "]"}], ",", "z"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"error0", "[", "z_", "]"}], ":=", 
     RowBox[{"PDF", "[", 
      RowBox[{
       RowBox[{"NormalDistribution", "[", 
        RowBox[{"0", ",", "\[Sigma]0"}], "]"}], ",", "z"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"p", "[", 
      RowBox[{
       RowBox[{"x_", "?", "NumericQ"}], ",", 
       RowBox[{"\[Lambda]1_", "?", "NumericQ"}], ",", 
       RowBox[{"\[Lambda]2_", "?", "NumericQ"}], ",", 
       RowBox[{"\[Lambda]3_", "?", "NumericQ"}], ",", 
       RowBox[{"\[Mu]1_", "?", "NumericQ"}], ",", 
       RowBox[{"\[Mu]2_", "?", "NumericQ"}], ",", 
       RowBox[{"\[Mu]3_", "?", "NumericQ"}], ",", 
       RowBox[{"\[Alpha]1_", "?", "NumericQ"}], ",", 
       RowBox[{"\[Alpha]2_", "?", "NumericQ"}], ",", 
       RowBox[{"\[Beta]1_", "?", "NumericQ"}], ",", 
       RowBox[{"\[Beta]2_", "?", "NumericQ"}], ",", 
       RowBox[{"\[Pi]1_", "?", "NumericQ"}], ",", 
       RowBox[{"\[Pi]2_", "?", "NumericQ"}], ",", 
       RowBox[{"\[Sigma]_", "?", "NumericQ"}]}], "]"}], ":=", 
     RowBox[{"NIntegrate", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"error", "[", 
         RowBox[{
          RowBox[{"x", "-", 
           RowBox[{"f", "[", 
            RowBox[{
            "z", ",", "\[Alpha]1", ",", "\[Alpha]2", ",", "\[Beta]1", ",", 
             "\[Beta]2", ",", "\[Pi]1", ",", "\[Pi]2"}], "]"}]}], ",", 
          "\[Sigma]"}], "]"}], "*", 
        RowBox[{"prior", "[", 
         RowBox[{
         "z", ",", "\[Lambda]1", ",", "\[Lambda]2", ",", "\[Lambda]3", ",", 
          "\[Mu]1", ",", "\[Mu]2", ",", "\[Mu]3"}], "]"}]}], ",", 
       RowBox[{"{", 
        RowBox[{"z", ",", 
         RowBox[{"-", "Infinity"}], ",", "Infinity"}], "}"}]}], "]"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"p0", "[", 
      RowBox[{"x_", "?", "NumericQ"}], "]"}], ":=", 
     RowBox[{"1.", "*", 
      RowBox[{"NIntegrate", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"error0", "[", 
          RowBox[{"x", "-", 
           RowBox[{"f0", "[", "z", "]"}]}], "]"}], "*", 
         RowBox[{"prior0", "[", "z", "]"}]}], ",", 
        RowBox[{"{", 
         RowBox[{"z", ",", 
          RowBox[{"-", "Infinity"}], ",", "Infinity"}], "}"}]}], "]"}]}]}], 
    ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Run", " ", "simulations"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"params", "=", "\"\<lambdas\>\""}], ";"}], "\[IndentingNewLine]", 
   
   RowBox[{
    RowBox[{"Export", "[", 
     RowBox[{"logfile", ",", "params"}], "]"}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"\[Theta]0", "=", "\[Lambda]10"}], ";", " ", 
    RowBox[{"(*", " ", 
     RowBox[{"ground", " ", "truth"}], " ", "*)"}], "\[IndentingNewLine]", 
    RowBox[{"\[Phi]0", "=", "\[Lambda]20"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"\[Psi]0", "=", "\[Lambda]30"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"param0", "=", 
     RowBox[{"{", 
      RowBox[{"\[Theta]0", ",", "\[Phi]0", ",", "\[Psi]0"}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"p0", "[", 
      RowBox[{
       RowBox[{"x_", "?", "NumericQ"}], ",", 
       RowBox[{"\[Theta]_", "?", "NumericQ"}], ",", 
       RowBox[{"\[Phi]_", "?", "NumericQ"}], ",", 
       RowBox[{"\[Psi]_", "?", "NumericQ"}]}], "]"}], ":=", 
     RowBox[{"p", "[", 
      RowBox[{
      "x", ",", "\[Theta]", ",", "\[Phi]", ",", "\[Psi]", ",", "\[Mu]10", ",",
        "\[Mu]20", ",", "\[Mu]30", ",", "\[Alpha]10", ",", "\[Alpha]20", ",", 
       "\[Beta]10", ",", "\[Beta]20", ",", "\[Pi]10", ",", "\[Pi]20", ",", 
       "\[Sigma]0"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"nll", "[", 
      RowBox[{
       RowBox[{"\[Theta]_", "?", "NumericQ"}], ",", 
       RowBox[{"\[Phi]_", "?", "NumericQ"}], ",", 
       RowBox[{"\[Psi]_", "?", "NumericQ"}]}], "]"}], ":=", 
     RowBox[{
      RowBox[{"-", "1."}], "*", 
      RowBox[{"NIntegrate", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"p0", "[", 
          RowBox[{"x", ",", "\[Theta]0", ",", "\[Phi]0", ",", "\[Psi]0"}], 
          "]"}], "*", 
         RowBox[{"Log", "[", 
          RowBox[{"p0", "[", 
           RowBox[{"x", ",", "\[Theta]", ",", "\[Phi]", ",", "\[Psi]"}], 
           "]"}], "]"}]}], ",", 
        RowBox[{"{", 
         RowBox[{"x", ",", 
          RowBox[{"-", "Infinity"}], ",", "Infinity"}], "}"}]}], "]"}]}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"nllgrid", "=", 
     RowBox[{"Parallelize", "[", 
      RowBox[{
       RowBox[{"EchoTiming", "@*", "nll"}], "@@@", "gridLAMBDAs"}], "]"}]}], 
    ";"}], " ", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"nllmins", "=", 
     RowBox[{"Flatten", "@", 
      RowBox[{"Position", "[", 
       RowBox[{"nllgrid", ",", 
        RowBox[{"Min", "[", "nllgrid", "]"}]}], "]"}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"out", "=", 
     RowBox[{"Map", "[", 
      RowBox[{"Flatten", ",", 
       RowBox[{"Thread", "[", 
        RowBox[{"{", 
         RowBox[{"gridLAMBDAs", ",", "nllgrid"}], "}"}], "]"}]}], "]"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"status", "=", "\"\<OK\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"simfile", "=", 
     RowBox[{
     "directory", "<>", "simid", "<>", "\"\<_\>\"", "<>", "status", "<>", 
      "\"\<_\>\"", "<>", "params", "<>", "\"\<_nmin\>\"", "<>", 
      RowBox[{"ToString", "[", 
       RowBox[{"Length", "@", "nllmins"}], "]"}], "<>", "\"\<.csv\>\""}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Export", "[", 
     RowBox[{"simfile", ",", 
      RowBox[{"N", "@", 
       RowBox[{"SortBy", "[", 
        RowBox[{"out", ",", "Last"}], "]"}]}], ",", "\"\<CSV\>\""}], "]"}], 
    ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"params", "=", "\"\<mus\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Export", "[", 
     RowBox[{"logfile", ",", "params"}], "]"}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"\[Theta]0", "=", "\[Mu]10"}], ";", " ", 
    RowBox[{"(*", " ", 
     RowBox[{"ground", " ", "truth"}], " ", "*)"}], "\[IndentingNewLine]", 
    RowBox[{"\[Phi]0", "=", "\[Mu]20"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"\[Psi]0", "=", "\[Mu]30"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"param0", "=", 
     RowBox[{"{", 
      RowBox[{"\[Theta]0", ",", "\[Phi]0", ",", "\[Psi]0"}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"p0", "[", 
      RowBox[{
       RowBox[{"x_", "?", "NumericQ"}], ",", 
       RowBox[{"\[Theta]_", "?", "NumericQ"}], ",", 
       RowBox[{"\[Phi]_", "?", "NumericQ"}], ",", 
       RowBox[{"\[Psi]_", "?", "NumericQ"}]}], "]"}], ":=", 
     RowBox[{"p", "[", 
      RowBox[{
      "x", ",", "\[Lambda]10", ",", "\[Lambda]20", ",", "\[Lambda]30", ",", 
       "\[Theta]", ",", "\[Phi]", ",", "\[Psi]", ",", "\[Alpha]10", ",", 
       "\[Alpha]20", ",", "\[Beta]10", ",", "\[Beta]20", ",", "\[Pi]10", ",", 
       "\[Pi]20", ",", "\[Sigma]0"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"nll", "[", 
      RowBox[{
       RowBox[{"\[Theta]_", "?", "NumericQ"}], ",", 
       RowBox[{"\[Phi]_", "?", "NumericQ"}], ",", 
       RowBox[{"\[Psi]_", "?", "NumericQ"}]}], "]"}], ":=", 
     RowBox[{
      RowBox[{"-", "1."}], "*", 
      RowBox[{"NIntegrate", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"p0", "[", 
          RowBox[{"x", ",", "\[Theta]0", ",", "\[Phi]0", ",", "\[Psi]0"}], 
          "]"}], "*", 
         RowBox[{"Log", "[", 
          RowBox[{"p0", "[", 
           RowBox[{"x", ",", "\[Theta]", ",", "\[Phi]", ",", "\[Psi]"}], 
           "]"}], "]"}]}], ",", 
        RowBox[{"{", 
         RowBox[{"x", ",", 
          RowBox[{"-", "Infinity"}], ",", "Infinity"}], "}"}]}], "]"}]}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"nllgrid", "=", 
     RowBox[{"Parallelize", "[", 
      RowBox[{
       RowBox[{"EchoTiming", "@*", "nll"}], "@@@", "gridMUs"}], "]"}]}], 
    ";"}], " ", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"nllmins", "=", 
     RowBox[{"Flatten", "@", 
      RowBox[{"Position", "[", 
       RowBox[{"nllgrid", ",", 
        RowBox[{"Min", "[", "nllgrid", "]"}]}], "]"}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"out", "=", 
     RowBox[{"Map", "[", 
      RowBox[{"Flatten", ",", 
       RowBox[{"Thread", "[", 
        RowBox[{"{", 
         RowBox[{"gridMUs", ",", "nllgrid"}], "}"}], "]"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"status", "=", "\"\<OK\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"simfile", "=", 
     RowBox[{
     "directory", "<>", "simid", "<>", "\"\<_\>\"", "<>", "status", "<>", 
      "\"\<_\>\"", "<>", "params", "<>", "\"\<_nmin\>\"", "<>", 
      RowBox[{"ToString", "[", 
       RowBox[{"Length", "@", "nllmins"}], "]"}], "<>", "\"\<.csv\>\""}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Export", "[", 
     RowBox[{"simfile", ",", 
      RowBox[{"N", "@", 
       RowBox[{"SortBy", "[", 
        RowBox[{"out", ",", "Last"}], "]"}]}], ",", "\"\<CSV\>\""}], "]"}], 
    ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"params", "=", "\"\<alphas\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Export", "[", 
     RowBox[{"logfile", ",", "params"}], "]"}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"\[Theta]0", "=", "\[Alpha]10"}], ";", " ", 
    RowBox[{"(*", " ", 
     RowBox[{"ground", " ", "truth"}], " ", "*)"}], "\[IndentingNewLine]", 
    RowBox[{"\[Phi]0", "=", "\[Alpha]20"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"param0", "=", 
     RowBox[{"{", 
      RowBox[{"\[Theta]0", ",", "\[Phi]0"}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"p0", "[", 
      RowBox[{
       RowBox[{"x_", "?", "NumericQ"}], ",", 
       RowBox[{"\[Theta]_", "?", "NumericQ"}], ",", 
       RowBox[{"\[Phi]_", "?", "NumericQ"}]}], "]"}], ":=", 
     RowBox[{"p", "[", 
      RowBox[{
      "x", ",", "\[Lambda]10", ",", "\[Lambda]20", ",", "\[Lambda]30", ",", 
       "\[Mu]10", ",", "\[Mu]20", ",", "\[Mu]30", ",", "\[Theta]", ",", 
       "\[Phi]", ",", "\[Beta]10", ",", "\[Beta]20", ",", "\[Pi]10", ",", 
       "\[Pi]20", ",", "\[Sigma]0"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"nll", "[", 
      RowBox[{
       RowBox[{"\[Theta]_", "?", "NumericQ"}], ",", 
       RowBox[{"\[Phi]_", "?", "NumericQ"}]}], "]"}], ":=", 
     RowBox[{
      RowBox[{"-", "1."}], "*", 
      RowBox[{"NIntegrate", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"p0", "[", 
          RowBox[{"x", ",", "\[Theta]0", ",", "\[Phi]0"}], "]"}], "*", 
         RowBox[{"Log", "[", 
          RowBox[{"p0", "[", 
           RowBox[{"x", ",", "\[Theta]", ",", "\[Phi]"}], "]"}], "]"}]}], ",", 
        RowBox[{"{", 
         RowBox[{"x", ",", 
          RowBox[{"-", "Infinity"}], ",", "Infinity"}], "}"}]}], "]"}]}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"nllgrid", "=", 
     RowBox[{"Parallelize", "[", 
      RowBox[{
       RowBox[{"EchoTiming", "@*", "nll"}], "@@@", "gridALPHAs"}], "]"}]}], 
    ";"}], " ", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"nllmins", "=", 
     RowBox[{"Flatten", "@", 
      RowBox[{"Position", "[", 
       RowBox[{"nllgrid", ",", 
        RowBox[{"Min", "[", "nllgrid", "]"}]}], "]"}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"out", "=", 
     RowBox[{"Map", "[", 
      RowBox[{"Flatten", ",", 
       RowBox[{"Thread", "[", 
        RowBox[{"{", 
         RowBox[{"gridALPHAs", ",", "nllgrid"}], "}"}], "]"}]}], "]"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"status", "=", "\"\<OK\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"simfile", "=", 
     RowBox[{
     "directory", "<>", "simid", "<>", "\"\<_\>\"", "<>", "status", "<>", 
      "\"\<_\>\"", "<>", "params", "<>", "\"\<_nmin\>\"", "<>", 
      RowBox[{"ToString", "[", 
       RowBox[{"Length", "@", "nllmins"}], "]"}], "<>", "\"\<.csv\>\""}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Export", "[", 
     RowBox[{"simfile", ",", 
      RowBox[{"N", "@", 
       RowBox[{"SortBy", "[", 
        RowBox[{"out", ",", "Last"}], "]"}]}], ",", "\"\<CSV\>\""}], "]"}], 
    ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"params", "=", "\"\<neurons\>\""}], ";"}], "\[IndentingNewLine]", 
   
   RowBox[{
    RowBox[{"Export", "[", 
     RowBox[{"logfile", ",", "params"}], "]"}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"\[Theta]0", "=", "\[Beta]10"}], ";", " ", 
    RowBox[{"(*", " ", 
     RowBox[{"ground", " ", "truth"}], " ", "*)"}], "\[IndentingNewLine]", 
    RowBox[{"\[Phi]0", "=", "\[Beta]20"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"\[Psi]0", "=", "\[Pi]10"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"\[Omega]0", "=", "\[Pi]20"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"param0", "=", 
     RowBox[{"{", 
      RowBox[{"\[Theta]0", ",", "\[Phi]0", ",", "\[Psi]0", ",", "\[Omega]0"}],
       "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"p0", "[", 
      RowBox[{
       RowBox[{"x_", "?", "NumericQ"}], ",", 
       RowBox[{"\[Theta]_", "?", "NumericQ"}], ",", 
       RowBox[{"\[Phi]_", "?", "NumericQ"}], ",", 
       RowBox[{"\[Psi]_", "?", "NumericQ"}], ",", 
       RowBox[{"\[Omega]_", "?", "NumericQ"}]}], "]"}], ":=", 
     RowBox[{"p", "[", 
      RowBox[{
      "x", ",", "\[Lambda]10", ",", "\[Lambda]20", ",", "\[Lambda]30", ",", 
       "\[Mu]10", ",", "\[Mu]20", ",", "\[Mu]30", ",", "\[Alpha]10", ",", 
       "\[Alpha]20", ",", "\[Theta]", ",", "\[Phi]", ",", "\[Psi]", ",", 
       "\[Omega]", ",", "\[Sigma]0"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   
   RowBox[{
    RowBox[{
     RowBox[{"nll", "[", 
      RowBox[{
       RowBox[{"\[Theta]_", "?", "NumericQ"}], ",", 
       RowBox[{"\[Phi]_", "?", "NumericQ"}], ",", 
       RowBox[{"\[Psi]_", "?", "NumericQ"}], ",", 
       RowBox[{"\[Omega]_", "?", "NumericQ"}]}], "]"}], ":=", 
     RowBox[{
      RowBox[{"-", "1."}], "*", 
      RowBox[{"NIntegrate", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"p0", "[", 
          RowBox[{
          "x", ",", "\[Theta]0", ",", "\[Phi]0", ",", "\[Psi]0", ",", 
           "\[Omega]0"}], "]"}], "*", 
         RowBox[{"Log", "[", 
          RowBox[{"p0", "[", 
           RowBox[{
           "x", ",", "\[Theta]", ",", "\[Phi]", ",", "\[Psi]", ",", 
            "\[Omega]"}], "]"}], "]"}]}], ",", 
        RowBox[{"{", 
         RowBox[{"x", ",", 
          RowBox[{"-", "Infinity"}], ",", "Infinity"}], "}"}]}], "]"}]}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"nllgrid", "=", 
     RowBox[{"Parallelize", "[", 
      RowBox[{
       RowBox[{"EchoTiming", "@*", "nll"}], "@@@", "gridNEURONs"}], "]"}]}], 
    ";"}], " ", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"nllmins", "=", 
     RowBox[{"Flatten", "@", 
      RowBox[{"Position", "[", 
       RowBox[{"nllgrid", ",", 
        RowBox[{"Min", "[", "nllgrid", "]"}]}], "]"}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"out", "=", 
     RowBox[{"Map", "[", 
      RowBox[{"Flatten", ",", 
       RowBox[{"Thread", "[", 
        RowBox[{"{", 
         RowBox[{"gridNEURONs", ",", "nllgrid"}], "}"}], "]"}]}], "]"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"status", "=", "\"\<OK\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"simfile", "=", 
     RowBox[{
     "directory", "<>", "simid", "<>", "\"\<_\>\"", "<>", "status", "<>", 
      "\"\<_\>\"", "<>", "params", "<>", "\"\<_nmin\>\"", "<>", 
      RowBox[{"ToString", "[", 
       RowBox[{"Length", "@", "nllmins"}], "]"}], "<>", "\"\<.csv\>\""}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Export", "[", 
     RowBox[{"simfile", ",", 
      RowBox[{"N", "@", 
       RowBox[{"SortBy", "[", 
        RowBox[{"out", ",", "Last"}], "]"}]}], ",", "\"\<CSV\>\""}], "]"}], 
    ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"DeleteFile", "[", "logfile", "]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"logfile", "=", 
     RowBox[{"directory", "<>", "simid", "<>", "\"\<_FINISH.txt\>\""}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Export", "[", 
     RowBox[{"logfile", ",", "\"\<\>\""}], "]"}], ";"}]}]}]], "Input",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmViYGAQBmIQ7WxdM1H66BtHq6zdk0C0x86JjzWBdGrvFDAtcbNe
zAhI2yhtEQfRzT9cZED0rfrpCiD6rj+/Boie82OLFoi+9nCCEYi+/2C7MYhe
sMo2BUS7aJwF02Wf+A+B6NXnPxwD0cURIUYBQPrRXl8TEK1xxNAfRH+q1w4A
0cunlGxsB9L+G1+DabnpWvtB9AxRXTC9/k35MRB9cWMlmH7zk1nQ/TjQvXr5
iiBaykBKC0RHVTDrgehP7fn2YPqBoCuIbgtm9QTRMTuZg0D0vcmFcSDaYdrv
BBB935Q7FUSfuXc6E0QDADrdoAs=
  
  "],ExpressionUUID->"8ab6980d-55e1-4139-9958-cf416b80dcd0"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\">> \"\>", "\[InvisibleSpace]", "6.980139`"}],
  SequenceForm[">> ", 6.980139],
  Editable->False]], "Print",
 ShowCellLabel->True,
 CellChangeTimes->{3.862575873164007*^9},
 CellLabel->
  "(kernel 9)",ExpressionUUID->"634d7dea-0be7-4b8c-946a-f9a674792c9a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\">> \"\>", "\[InvisibleSpace]", "7.24896`"}],
  SequenceForm[">> ", 7.24896],
  Editable->False]], "Print",
 ShowCellLabel->True,
 CellChangeTimes->{3.862575873497636*^9},
 CellLabel->
  "(kernel 7)",ExpressionUUID->"44e8f292-d9ce-4b38-bd0c-62175cca6a68"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\">> \"\>", "\[InvisibleSpace]", "8.319316`"}],
  SequenceForm[">> ", 8.319316],
  Editable->False]], "Print",
 ShowCellLabel->True,
 CellChangeTimes->{3.862575874498992*^9},
 CellLabel->
  "(kernel 8)",ExpressionUUID->"d3d7357f-3f7d-481c-a682-bd9f4a9d765e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\">> \"\>", "\[InvisibleSpace]", "8.565258`"}],
  SequenceForm[">> ", 8.565258],
  Editable->False]], "Print",
 ShowCellLabel->True,
 CellChangeTimes->{3.862575874743019*^9},
 CellLabel->
  "(kernel 5)",ExpressionUUID->"824fe15d-7145-4bb5-b21f-e5266df447d9"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\">> \"\>", "\[InvisibleSpace]", "9.325218`"}],
  SequenceForm[">> ", 9.325218],
  Editable->False]], "Print",
 ShowCellLabel->True,
 CellChangeTimes->{3.862575875513109*^9},
 CellLabel->
  "(kernel 6)",ExpressionUUID->"8852dad4-f5c2-451d-9991-5562c92e8e49"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\">> \"\>", "\[InvisibleSpace]", "9.346722`"}],
  SequenceForm[">> ", 9.346722],
  Editable->False]], "Print",
 ShowCellLabel->True,
 CellChangeTimes->{3.8625758755323763`*^9},
 CellLabel->
  "(kernel 2)",ExpressionUUID->"44459419-ea46-47db-802f-4f93623b210e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\">> \"\>", "\[InvisibleSpace]", "9.379665`"}],
  SequenceForm[">> ", 9.379665],
  Editable->False]], "Print",
 ShowCellLabel->True,
 CellChangeTimes->{3.862575875565359*^9},
 CellLabel->
  "(kernel 4)",ExpressionUUID->"2a1d4966-25f7-4881-8013-ccab51ff7987"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\">> \"\>", "\[InvisibleSpace]", "9.381667`"}],
  SequenceForm[">> ", 9.381667],
  Editable->False]], "Print",
 ShowCellLabel->True,
 CellChangeTimes->{3.8625758755764923`*^9},
 CellLabel->
  "(kernel 3)",ExpressionUUID->"4d289c2d-abef-459a-bc86-3f01267dd184"]
}, Open  ]],

Cell[BoxData["$Aborted"], "Output",
 CellChangeTimes->{
  3.861659206781406*^9, 3.8625755366745443`*^9, 3.862575637640156*^9, 
   3.8625757799247837`*^9, {3.862575846150298*^9, 3.8625758756319838`*^9}},
 CellLabel->
  "Out[548]=",ExpressionUUID->"ae1cc365-7066-4424-8eaf-f5fd9f21a3e7"],

Cell[BoxData["$Aborted"], "Output",
 CellChangeTimes->{
  3.861659206781406*^9, 3.8625755366745443`*^9, 3.862575637640156*^9, 
   3.8625757799247837`*^9, {3.862575846150298*^9, 3.862575875742406*^9}},
 CellLabel->
  "Out[561]=",ExpressionUUID->"966a7014-4391-4b7d-b0cd-a17551a8eb62"],

Cell[BoxData[
 TemplateBox[{
  "Thread", "tdlen", 
   "\"Objects of unequal length in \\!\\(\\*RowBox[{\\\"{\\\", \
RowBox[{RowBox[{\\\"{\\\", RowBox[{RowBox[{\\\"{\\\", RowBox[{RowBox[{\\\"-\\\
\", \\\"1.`\\\"}], \\\",\\\", RowBox[{\\\"-\\\", \\\"1.`\\\"}], \\\",\\\", \
RowBox[{\\\"-\\\", \\\"1.`\\\"}]}], \\\"}\\\"}], \\\",\\\", \
RowBox[{\\\"{\\\", RowBox[{RowBox[{\\\"-\\\", \\\"1.`\\\"}], \\\",\\\", \
RowBox[{\\\"-\\\", \\\"1.`\\\"}], \\\",\\\", RowBox[{\\\"-\\\", \
\\\"0.875`\\\"}]}], \\\"}\\\"}], \\\",\\\", RowBox[{\\\"{\\\", \
RowBox[{RowBox[{\\\"-\\\", \\\"1.`\\\"}], \\\",\\\", RowBox[{\\\"-\\\", \
\\\"1.`\\\"}], \\\",\\\", RowBox[{\\\"-\\\", \\\"0.75`\\\"}]}], \\\"}\\\"}], \
\\\",\\\", RowBox[{\\\"{\\\", RowBox[{RowBox[{\\\"-\\\", \\\"1.`\\\"}], \\\",\
\\\", RowBox[{\\\"-\\\", \\\"1.`\\\"}], \\\",\\\", RowBox[{\\\"-\\\", \
\\\"0.625`\\\"}]}], \\\"}\\\"}], \\\",\\\", RowBox[{\\\"{\\\", \
RowBox[{RowBox[{\\\"-\\\", \\\"1.`\\\"}], \\\",\\\", RowBox[{\\\"-\\\", \
\\\"1.`\\\"}], \\\",\\\", RowBox[{\\\"-\\\", \\\"0.5`\\\"}]}], \\\"}\\\"}], \
\\\",\\\", RowBox[{\\\"{\\\", RowBox[{RowBox[{\\\"-\\\", \\\"1.`\\\"}], \\\",\
\\\", RowBox[{\\\"-\\\", \\\"1.`\\\"}], \\\",\\\", RowBox[{\\\"-\\\", \
\\\"0.375`\\\"}]}], \\\"}\\\"}], \\\",\\\", RowBox[{\\\"{\\\", \
RowBox[{RowBox[{\\\"-\\\", \\\"1.`\\\"}], \\\",\\\", RowBox[{\\\"-\\\", \
\\\"1.`\\\"}], \\\",\\\", RowBox[{\\\"-\\\", \\\"0.25`\\\"}]}], \\\"}\\\"}], \
\\\",\\\", RowBox[{\\\"{\\\", RowBox[{RowBox[{\\\"-\\\", \\\"1.`\\\"}], \\\",\
\\\", RowBox[{\\\"-\\\", \\\"1.`\\\"}], \\\",\\\", RowBox[{\\\"-\\\", \
\\\"0.125`\\\"}]}], \\\"}\\\"}], \\\",\\\", RowBox[{\\\"{\\\", \
RowBox[{RowBox[{\\\"-\\\", \\\"1.`\\\"}], \\\",\\\", RowBox[{\\\"-\\\", \
\\\"1.`\\\"}], \\\",\\\", \\\"0.`\\\"}], \\\"}\\\"}], \\\",\\\", \
RowBox[{\\\"{\\\", RowBox[{RowBox[{\\\"-\\\", \\\"1.`\\\"}], \\\",\\\", \
RowBox[{\\\"-\\\", \\\"1.`\\\"}], \\\",\\\", \\\"0.125`\\\"}], \\\"}\\\"}], \
\\\",\\\", RowBox[{\\\"\[LeftSkeleton]\\\", \\\"4903\\\", \
\\\"\[RightSkeleton]\\\"}]}], \\\"}\\\"}], \\\",\\\", RowBox[{\\\"{\\\", \
RowBox[{\\\"1.5052672746305433`\\\", \\\",\\\", \\\"1.48258184039763`\\\", \\\
\",\\\", \\\"1.4621587143095853`\\\", \\\",\\\", \\\"1.443565304551763`\\\", \
\\\",\\\", \\\"1.4265046054279231`\\\", \\\",\\\", \
\\\"1.410759442840942`\\\", \\\",\\\", \\\"1.3961643008631097`\\\", \
\\\",\\\", \\\"1.3825892267731374`\\\", \\\",\\\", \
\\\"1.3699298689033959`\\\", \\\",\\\", \\\"1.358100957119172`\\\", \
\\\",\\\", RowBox[{\\\"\[LeftSkeleton]\\\", \\\"221\\\", \\\"\[RightSkeleton]\
\\\"}]}], \\\"}\\\"}]}], \\\"}\\\"}]\\) cannot be combined.\"", 2, 563, 28, 
   26781171157534855940, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{
  3.862575583097344*^9, 3.862575638012542*^9, 3.862575746086466*^9, {
   3.862575847327153*^9, 3.862575875755415*^9}},
 CellLabel->
  "During evaluation of \
In[478]:=",ExpressionUUID->"7e68c666-514a-4d88-9cf0-24a5d92e7b1b"],

Cell[BoxData["$Aborted"], "Output",
 CellChangeTimes->{
  3.861659206781406*^9, 3.8625755366745443`*^9, 3.862575637640156*^9, 
   3.8625757799247837`*^9, {3.862575846150298*^9, 3.862575875976153*^9}},
 CellLabel->
  "Out[573]=",ExpressionUUID->"e205d68d-7406-4f28-b6fc-3ef3322ee309"],

Cell[BoxData[
 TemplateBox[{
  "Thread", "tdlen", 
   "\"Objects of unequal length in \\!\\(\\*RowBox[{\\\"{\\\", \
RowBox[{RowBox[{\\\"{\\\", RowBox[{RowBox[{\\\"{\\\", RowBox[{RowBox[{\\\"-\\\
\", \\\"2.`\\\"}], \\\",\\\", RowBox[{\\\"-\\\", \\\"2.`\\\"}]}], \
\\\"}\\\"}], \\\",\\\", RowBox[{\\\"{\\\", RowBox[{RowBox[{\\\"-\\\", \\\"2.`\
\\\"}], \\\",\\\", RowBox[{\\\"-\\\", \\\"1.8`\\\"}]}], \\\"}\\\"}], \
\\\",\\\", RowBox[{\\\"{\\\", RowBox[{RowBox[{\\\"-\\\", \\\"2.`\\\"}], \\\",\
\\\", RowBox[{\\\"-\\\", \\\"1.6`\\\"}]}], \\\"}\\\"}], \\\",\\\", RowBox[{\\\
\"{\\\", RowBox[{RowBox[{\\\"-\\\", \\\"2.`\\\"}], \\\",\\\", RowBox[{\\\"-\\\
\", \\\"1.4`\\\"}]}], \\\"}\\\"}], \\\",\\\", RowBox[{\\\"{\\\", \
RowBox[{RowBox[{\\\"-\\\", \\\"2.`\\\"}], \\\",\\\", RowBox[{\\\"-\\\", \
\\\"1.2`\\\"}]}], \\\"}\\\"}], \\\",\\\", RowBox[{\\\"{\\\", RowBox[{RowBox[{\
\\\"-\\\", \\\"2.`\\\"}], \\\",\\\", RowBox[{\\\"-\\\", \\\"1.`\\\"}]}], \
\\\"}\\\"}], \\\",\\\", RowBox[{\\\"{\\\", RowBox[{RowBox[{\\\"-\\\", \\\"2.`\
\\\"}], \\\",\\\", RowBox[{\\\"-\\\", \\\"0.8`\\\"}]}], \\\"}\\\"}], \
\\\",\\\", RowBox[{\\\"{\\\", RowBox[{RowBox[{\\\"-\\\", \\\"2.`\\\"}], \\\",\
\\\", RowBox[{\\\"-\\\", \\\"0.6`\\\"}]}], \\\"}\\\"}], \\\",\\\", RowBox[{\\\
\"{\\\", RowBox[{RowBox[{\\\"-\\\", \\\"2.`\\\"}], \\\",\\\", RowBox[{\\\"-\\\
\", \\\"0.4`\\\"}]}], \\\"}\\\"}], \\\",\\\", RowBox[{\\\"{\\\", \
RowBox[{RowBox[{\\\"-\\\", \\\"2.`\\\"}], \\\",\\\", RowBox[{\\\"-\\\", \
\\\"0.2`\\\"}]}], \\\"}\\\"}], \\\",\\\", RowBox[{\\\"\[LeftSkeleton]\\\", \\\
\"431\\\", \\\"\[RightSkeleton]\\\"}]}], \\\"}\\\"}], \\\",\\\", \
RowBox[{\\\"{\\\", RowBox[{\\\"1.5052672746305433`\\\", \\\",\\\", \
\\\"1.48258184039763`\\\", \\\",\\\", \\\"1.4621587143095853`\\\", \\\",\\\", \
\\\"1.443565304551763`\\\", \\\",\\\", \\\"1.4265046054279231`\\\", \
\\\",\\\", \\\"1.410759442840942`\\\", \\\",\\\", \
\\\"1.3961643008631097`\\\", \\\",\\\", \\\"1.3825892267731374`\\\", \
\\\",\\\", \\\"1.3699298689033959`\\\", \\\",\\\", \
\\\"1.358100957119172`\\\", \\\",\\\", RowBox[{\\\"\[LeftSkeleton]\\\", \
\\\"221\\\", \\\"\[RightSkeleton]\\\"}]}], \\\"}\\\"}]}], \\\"}\\\"}]\\) \
cannot be combined.\"", 2, 575, 29, 26781171157534855940, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{
  3.862575583097344*^9, 3.862575638012542*^9, 3.862575746086466*^9, {
   3.862575847327153*^9, 3.862575875982402*^9}},
 CellLabel->
  "During evaluation of \
In[478]:=",ExpressionUUID->"d59e6d4e-9481-4c9c-87a4-d59ee98f90c4"],

Cell[BoxData["$Aborted"], "Output",
 CellChangeTimes->{
  3.861659206781406*^9, 3.8625755366745443`*^9, 3.862575637640156*^9, 
   3.8625757799247837`*^9, {3.862575846150298*^9, 3.862575876133835*^9}},
 CellLabel->
  "Out[587]=",ExpressionUUID->"71c6bfb0-a6c7-4ed7-87e8-1f1d17393bc0"],

Cell[BoxData[
 TemplateBox[{
  "Thread", "tdlen", 
   "\"Objects of unequal length in \\!\\(\\*RowBox[{\\\"{\\\", \
RowBox[{RowBox[{\\\"{\\\", RowBox[{RowBox[{\\\"{\\\", RowBox[{RowBox[{\\\"-\\\
\", \\\"1.`\\\"}], \\\",\\\", RowBox[{\\\"-\\\", \\\"1.`\\\"}], \\\",\\\", \
RowBox[{\\\"-\\\", \\\"1.`\\\"}], \\\",\\\", RowBox[{\\\"-\\\", \
\\\"1.`\\\"}]}], \\\"}\\\"}], \\\",\\\", RowBox[{\\\"{\\\", \
RowBox[{RowBox[{\\\"-\\\", \\\"1.`\\\"}], \\\",\\\", RowBox[{\\\"-\\\", \
\\\"1.`\\\"}], \\\",\\\", RowBox[{\\\"-\\\", \\\"1.`\\\"}], \\\",\\\", \
RowBox[{\\\"-\\\", \\\"0.75`\\\"}]}], \\\"}\\\"}], \\\",\\\", RowBox[{\\\"{\\\
\", RowBox[{RowBox[{\\\"-\\\", \\\"1.`\\\"}], \\\",\\\", RowBox[{\\\"-\\\", \
\\\"1.`\\\"}], \\\",\\\", RowBox[{\\\"-\\\", \\\"1.`\\\"}], \\\",\\\", \
RowBox[{\\\"-\\\", \\\"0.5`\\\"}]}], \\\"}\\\"}], \\\",\\\", \
RowBox[{\\\"{\\\", RowBox[{RowBox[{\\\"-\\\", \\\"1.`\\\"}], \\\",\\\", \
RowBox[{\\\"-\\\", \\\"1.`\\\"}], \\\",\\\", RowBox[{\\\"-\\\", \
\\\"1.`\\\"}], \\\",\\\", RowBox[{\\\"-\\\", \\\"0.25`\\\"}]}], \\\"}\\\"}], \
\\\",\\\", RowBox[{\\\"{\\\", RowBox[{RowBox[{\\\"-\\\", \\\"1.`\\\"}], \\\",\
\\\", RowBox[{\\\"-\\\", \\\"1.`\\\"}], \\\",\\\", RowBox[{\\\"-\\\", \\\"1.`\
\\\"}], \\\",\\\", \\\"0.`\\\"}], \\\"}\\\"}], \\\",\\\", RowBox[{\\\"{\\\", \
RowBox[{RowBox[{\\\"-\\\", \\\"1.`\\\"}], \\\",\\\", RowBox[{\\\"-\\\", \
\\\"1.`\\\"}], \\\",\\\", RowBox[{\\\"-\\\", \\\"1.`\\\"}], \\\",\\\", \
\\\"0.25`\\\"}], \\\"}\\\"}], \\\",\\\", RowBox[{\\\"{\\\", \
RowBox[{RowBox[{\\\"-\\\", \\\"1.`\\\"}], \\\",\\\", RowBox[{\\\"-\\\", \
\\\"1.`\\\"}], \\\",\\\", RowBox[{\\\"-\\\", \\\"1.`\\\"}], \\\",\\\", \
\\\"0.5`\\\"}], \\\"}\\\"}], \\\",\\\", RowBox[{\\\"{\\\", RowBox[{RowBox[{\\\
\"-\\\", \\\"1.`\\\"}], \\\",\\\", RowBox[{\\\"-\\\", \\\"1.`\\\"}], \
\\\",\\\", RowBox[{\\\"-\\\", \\\"1.`\\\"}], \\\",\\\", \\\"0.75`\\\"}], \
\\\"}\\\"}], \\\",\\\", RowBox[{\\\"{\\\", RowBox[{RowBox[{\\\"-\\\", \\\"1.`\
\\\"}], \\\",\\\", RowBox[{\\\"-\\\", \\\"1.`\\\"}], \\\",\\\", RowBox[{\\\"-\
\\\", \\\"1.`\\\"}], \\\",\\\", \\\"1.`\\\"}], \\\"}\\\"}], \\\",\\\", \
RowBox[{\\\"{\\\", RowBox[{RowBox[{\\\"-\\\", \\\"1.`\\\"}], \\\",\\\", \
RowBox[{\\\"-\\\", \\\"1.`\\\"}], \\\",\\\", RowBox[{\\\"-\\\", \
\\\"0.75`\\\"}], \\\",\\\", RowBox[{\\\"-\\\", \\\"1.`\\\"}]}], \\\"}\\\"}], \
\\\",\\\", RowBox[{\\\"\[LeftSkeleton]\\\", \\\"6551\\\", \
\\\"\[RightSkeleton]\\\"}]}], \\\"}\\\"}], \\\",\\\", RowBox[{\\\"{\\\", \
RowBox[{\\\"1.5052672746305433`\\\", \\\",\\\", \\\"1.48258184039763`\\\", \\\
\",\\\", \\\"1.4621587143095853`\\\", \\\",\\\", \\\"1.443565304551763`\\\", \
\\\",\\\", \\\"1.4265046054279231`\\\", \\\",\\\", \
\\\"1.410759442840942`\\\", \\\",\\\", \\\"1.3961643008631097`\\\", \
\\\",\\\", \\\"1.3825892267731374`\\\", \\\",\\\", \
\\\"1.3699298689033959`\\\", \\\",\\\", \\\"1.358100957119172`\\\", \
\\\",\\\", RowBox[{\\\"\[LeftSkeleton]\\\", \\\"221\\\", \\\"\[RightSkeleton]\
\\\"}]}], \\\"}\\\"}]}], \\\"}\\\"}]\\) cannot be combined.\"", 2, 589, 30, 
   26781171157534855940, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{
  3.862575583097344*^9, 3.862575638012542*^9, 3.862575746086466*^9, {
   3.862575847327153*^9, 3.862575876149085*^9}},
 CellLabel->
  "During evaluation of \
In[478]:=",ExpressionUUID->"1cdb378a-f151-46ae-85ed-e7c50c7cf990"]
}, Open  ]]
},
WindowSize->{1280, 1387},
WindowMargins->{{573, Automatic}, {Automatic, 0}},
FrontEndVersion->"13.0 for Mac OS X x86 (64-bit) (February 4, 2022)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"e8491a7c-9881-49a5-91eb-1eff6a620ef6"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[580, 22, 31689, 859, 3202, "Input",ExpressionUUID->"8ab6980d-55e1-4139-9958-cf416b80dcd0"],
Cell[CellGroupData[{
Cell[32294, 885, 305, 8, 24, "Print",ExpressionUUID->"634d7dea-0be7-4b8c-946a-f9a674792c9a"],
Cell[32602, 895, 303, 8, 24, "Print",ExpressionUUID->"44e8f292-d9ce-4b38-bd0c-62175cca6a68"],
Cell[32908, 905, 305, 8, 24, "Print",ExpressionUUID->"d3d7357f-3f7d-481c-a682-bd9f4a9d765e"],
Cell[33216, 915, 305, 8, 24, "Print",ExpressionUUID->"824fe15d-7145-4bb5-b21f-e5266df447d9"],
Cell[33524, 925, 305, 8, 24, "Print",ExpressionUUID->"8852dad4-f5c2-451d-9991-5562c92e8e49"],
Cell[33832, 935, 307, 8, 24, "Print",ExpressionUUID->"44459419-ea46-47db-802f-4f93623b210e"],
Cell[34142, 945, 305, 8, 24, "Print",ExpressionUUID->"2a1d4966-25f7-4881-8013-ccab51ff7987"],
Cell[34450, 955, 307, 8, 24, "Print",ExpressionUUID->"4d289c2d-abef-459a-bc86-3f01267dd184"]
}, Open  ]],
Cell[34772, 966, 285, 5, 34, "Output",ExpressionUUID->"ae1cc365-7066-4424-8eaf-f5fd9f21a3e7"],
Cell[35060, 973, 283, 5, 34, "Output",ExpressionUUID->"966a7014-4391-4b7d-b0cd-a17551a8eb62"],
Cell[35346, 980, 2953, 46, 63, "Message",ExpressionUUID->"7e68c666-514a-4d88-9cf0-24a5d92e7b1b"],
Cell[38302, 1028, 283, 5, 34, "Output",ExpressionUUID->"e205d68d-7406-4f28-b6fc-3ef3322ee309"],
Cell[38588, 1035, 2516, 39, 63, "Message",ExpressionUUID->"d59e6d4e-9481-4c9c-87a4-d59ee98f90c4"],
Cell[41107, 1076, 283, 5, 34, "Output",ExpressionUUID->"71c6bfb0-a6c7-4ed7-87e8-1f1d17393bc0"],
Cell[41393, 1083, 3342, 51, 63, "Message",ExpressionUUID->"1cdb378a-f151-46ae-85ed-e7c50c7cf990"]
}, Open  ]]
}
]
*)

