# Instruction Tagging Guidelines

This document defines categories for classifying coding instructions, combining style/readability, structural, performance, correctness, and algorithm-level modifications.

---

## Cosmetic (Style & Readability)
Changes that affect readability, style, or surface presentation, but not the underlying logic.

**Examples:**
* “Add more comments.”
* “Rename variables to be more descriptive.”
* “Format the code using 4-space indentation.”
* “Use snake_case for variable names.”

**Key cues:**
* Mentions of comments, naming, formatting, indentation, or style.
* No requirement to alter control flow, data structures, or algorithms.

---

## Structural
Changes that modify the form or structure of the implementation, often requiring specific constructs or data structures. The logic of the solution may stay the same, but the way it is written changes.

**Examples:**
* “Use nested for loops instead of a single loop.”
* “Implement the solution using recursion.”
* “Replace the if-else chain with a switch statement.”
* “Use a stack to solve the problem instead of recursion.”

**Key cues:**
* Mentions of loops, recursion, iteration style, or control structures.
* Explicit requirements about which data structure to use (array, linked list, tree, hash map).
* Refactorings that affect code shape but not the fundamental task.

---

## Performance & Optimization
Instructions that directly target the code's runtime performance (time complexity) or resource usage (space complexity). The goal is to make the code run faster or consume less memory by optimizing computations, reducing redundant work, and managing resources more effectively.

**Examples:**
* “Ensure the solution runs in O(n log n).”
* “Parallelize the code to run on multiple threads.”
* “Optimize memory usage by avoiding unnecessary copies.”

**Key cues:**
* Mentions of efficiency, optimization, complexity (time/memory).
* Requires modifying code to improve runtime or resource usage without changing the high-level algorithm.

---

## Correctness & Robustness
Instructions aimed at ensuring the code functions as intended without errors, handles edge cases gracefully, and is resilient to unexpected inputs or states. The goal is to prevent bugs, crashes, and unpredictable behavior.

**Examples:**
* “Modify the algorithm to work for negative numbers as well.”
* “Add checks to handle null inputs safely.”
* “Ensure all exceptions are properly caught.”

**Key cues:**
* Mentions of correctness, validation, error handling, or robustness.
* Requires changes that affect the logic to handle edge cases or avoid bugs.

---

## Algorithm Modification
Instructions that involve a fundamental change in the high-level problem-solving strategy. This is distinct from micro-optimizations; it's about replacing the core logic with a different, named algorithmic paradigm.

**Examples:**
* “Change the approach from brute force to dynamic programming.”
* “Replace a recursive solution with an iterative divide-and-conquer approach.”
* “Switch from a hash map based solution to a tree-based solution.”

**Key cues:**
* Requires redesign of the main algorithm.
* Involves changing the overall problem-solving strategy rather than surface-level improvements.

---

## Vague
If the instruction ID, the description, or the user strings in the proper JSON file are not clear enough to understand what the instruction is, tag them as vague.

**Example:**
* Instruction `add-grouping-logic` with only user string “add grouping logic” is unclear about what the developer wants to achieve.
