from instructions.BaseInstruction import Language
from instructions.GenericCOTInstruction import GenericCOTInstruction
import json

def match_lang(lang: str):
    if lang == "go":
        return Language.GO
    elif lang == "python":
        return Language.PYTHON
    elif lang == "java":
        return Language.JAVA
    elif lang == "javascript":
        return Language.JAVASCRIPT
    elif lang == "swift":
        return Language.SWIFT
    else:
        raise ValueError(f"Unsupported language: {lang}")

# Want this to be loaded ONCE when the module is imported
with open("instructions/all_instructions.json") as f:
    ALL_INSTRUCTIONS = json.load(f)
    for inst in ALL_INSTRUCTIONS:
        inst["languages"] = [match_lang(x) for x in inst["languages"]]

FILTERED_GENERIC = None


def make_generic_instructions(inst_dict_list):
    ret = []
    for instr_params in inst_dict_list:
        ret.append(GenericCOTInstruction(**instr_params))
    
    return ret

def get_categories(lang: Language):
    global FILTERED_GENERIC 
    if not FILTERED_GENERIC:
        list_to_construct = []
        for instr in ALL_INSTRUCTIONS:
            if lang in instr["languages"]:
                list_to_construct.append(instr)
        FILTERED_GENERIC = make_generic_instructions(list_to_construct)

    rule_based_instrs = [] # TODO: add rule based instructions
    return FILTERED_GENERIC + rule_based_instrs

