package com.xxx.amp.magenta.livecodebench;

import com.xxx.amp.magenta.livecodebench.solution.CanSortSolution;
import com.xxx.amp.magenta.livecodebench.solution.MinimumCostSolution;
import org.json.JSONObject;
import org.junit.jupiter.api.Test;

import java.nio.file.Files;
import java.nio.file.Path;

import static org.junit.jupiter.api.Assertions.assertThrows;

public class FuncCallSuiteTest {

    @Test
    public void testPositiveFlow() throws Throwable {
        String input = this.getClass()
                .getResource("/FuncCallTestSuiteTest1.json")
                .getFile();

        JSONObject data = new JSONObject(Files.readString(Path.of(input)));

        FuncCallSuite suite = new FuncCallSuite(MinimumCostSolution.class);
        suite.load(new JSONObject(data.getString("input_output")));

        suite.run(1000);
    }

    @Test
    public void testCanSortArray() throws Throwable {
        String input = this.getClass()
                .getResource("/CanSortTest.json")
                .getFile();

        JSONObject data = new JSONObject(Files.readString(Path.of(input)));

        FuncCallSuite suite = new FuncCallSuite(CanSortSolution.class);
        assertThrows(LiteralSyntaxException.class, () -> {
                    // Testcase definition contains BigInteger values
                    suite.load(new JSONObject(data.getString("input_output")));
                    suite.run(1000);
                }
        );
    }
}
