package com.xxx.amp.magenta.livecodebench;

import com.xxx.amp.magenta.livecodebench.model.TestRun;
import com.xxx.amp.magenta.livecodebench.model.TestStatus;
import com.xxx.amp.magenta.livecodebench.solution.StrLenSolution;
import org.json.JSONObject;
import org.junit.jupiter.api.Test;

import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;

import static org.junit.jupiter.api.Assertions.assertEquals;

public class StdioSuiteTest {

    @Test
    public void testPositiveFlow() throws Throwable {
        String input = this.getClass()
                .getResource("/StdioTestStrLen.json")
                .getFile();

        JSONObject data = new JSONObject(Files.readString(Path.of(input)));

        StdioSuite suite = new StdioSuite(StrLenSolution.class);
        suite.load(new JSONObject(data.getString("input_output")));

        assertEquals(List.of("300\n", "3\n"), suite.inputs);
        assertEquals(List.of("3\n", "1\n"), suite.outputs);

        List<TestRun> results = suite.run(1000);

        TestRun result0 = results.get(0);
        assertEquals(TestStatus.PASSED, result0.getStatus());
        assertEquals("3", result0.getOutput());

        TestRun result1 = results.get(1);
        assertEquals(TestStatus.PASSED, result1.getStatus());
        assertEquals("1", result1.getOutput());
    }

    @Test
    public void testAssertFailure() throws Throwable {
        String input = this.getClass()
                .getResource("/StdioTestStrLen-Failed.json")
                .getFile();

        JSONObject data = new JSONObject(Files.readString(Path.of(input)));

        StdioSuite suite = new StdioSuite(StrLenSolution.class);
        suite.load(new JSONObject(data.getString("input_output")));

        assertEquals(List.of("300\n", "3\n"), suite.inputs);
        assertEquals(List.of("2\n", "2\n"), suite.outputs);

        List<TestRun> results = suite.run(1000);

        TestRun result0 = results.get(0);
        assertEquals(TestStatus.FAILED, result0.getStatus());
        assertEquals("3", result0.getOutput());

        TestRun result1 = results.get(1);
        assertEquals(TestStatus.FAILED, result1.getStatus());
        assertEquals("1", result1.getOutput());
    }
}
