import abc
from typing import Optional

from pydantic import BaseModel


class LCBCorrectnessCriteria(BaseModel):
    question_id: str
    question_title: str
    prompt: str
    fn_name: Optional[str]
    test_inputs: list[str]
    test_outputs: list[str]


class GenerationCorrectnessEvaluator(abc.ABC):
    @abc.abstractmethod
    def check(self, problem: LCBCorrectnessCriteria, generation: str, timeout: int = 60, debug: bool = True) -> bool:
        """
        checks if the given generated code passes tests in the problem definition.

        :param problem: an object with a task description
        :param generation: the generated code to test
        :param timeout: timeout in seconds
        :param debug: enable print out of debug information
        :return: True if all tests pass, False otherwise
        """
        pass