#!/bin/bash
set -x -e

WORK_DIR=$1
RUNNER_JAR=${LB_JAVA_RUNNER_JAR:-$HOME/.m2/repository/com/xxx/amp/magenta/lb-java/1.0-SNAPSHOT/lb-java-1.0-SNAPSHOT-all.jar}
shift

SRC_DIR=$WORK_DIR/src
TARGET_DIR=$WORK_DIR/target
mkdir -p "$TARGET_DIR"

# Exit with code 2 if compilation fails
javac $SRC_DIR/*.java -d $TARGET_DIR || exit 2

# Application parameters:
# <Input file with tests> <Output file with the results> <timeout for each test>
java -Xmx2g -cp $TARGET_DIR:$RUNNER_JAR com.xxx.amp.magenta.livecodebench.Runner "$1" "$2" "$3"

# Success
exit 0
