"""
Pipeline module for code instruction following experiments.

This module provides functionality for running instruction following experiments
on code generation models, including question processing, answer generation,
and evaluation.
"""

from .pipeline_utils import (
    match_lang,
    get_question,
    get_answers,
    get_categories,
    sample_categories,
    sample_user_strings,
    construct_question,
    IF_eval
)
from .models import (
    construct_client,
    openai_call,
    generate_answer,
    CLAUDE_MODELS,
    CLAUDE_MAP,
    GEMINI_MODELS,
    GPT_MAP
)

__all__ = [
    'match_lang',
    'get_question',
    'get_answers',
    'get_categories',
    'sample_categories',
    'sample_user_strings',
    'construct_question',
    'IF_eval',
    'construct_client',
    'openai_call',
    'generate_answer',
    'CLAUDE_MODELS',
    'CLAUDE_MAP',
    'GEMINI_MODELS',
    'GPT_MAP'
]