# Unconstrained Objective for Multi-View Learning: Fast PLS, CCA, and Deep CCA

This repository contains the code for the paper "Unconstrained Objective for Multi-View Learning: Fast PLS, CCA, and Deep CCA".

We use wandb to log the experiments. To run the experiments, you need to set up a wandb account and set the environment variable `WANDB_API_KEY` to your API key. You can find your API key in your account settings.

## Data

The data for the experiments can be downloaded by running the relevant scripts with the working directory set to the root of this repository

## Requirements

The code is written in Python 3.9 and requires the packages in `requirements.txt`. To install them, run

```
pip install -r requirements.txt
```

## Experiments

### Stochastic CCA

To run the experiments for stochastic CCA, run

```
python -m experiments/stochastic_cca/train.py
```

To change the arguments, change the default values in `train.py`

### Deep CCA

To run the experiments for deep CCA, run

```
python -m experiments/deep_cca/train.py
```

To change the arguments, change the default values in `train.py`

### Deep MCCA

To run the experiments for deep MCCA, run

```
python -m experiments/deep_mcca/train.py
```

To change the arguments, change the default values in `train.py`

