## Safety-aware Policy Optimisation for Autonomous Racing (SPAR)

<div align="center">
  <br>
  <img src='./assets/images/spar_framework_figure.png' alt='An overview of the SPAR methodology'/ width=80%>
  <p style="padding: 20px 20px 20px 20px;"><i>An overview of the SPAR methodology</i></p>
  <br>
</div>

Without safety constraints, autonomous agents are not guaranteed to adhere to safe behaviours, throughout interactions with their environment. In the context of safety-critical control applications, such as autonomous driving and human-robot interaction, recent literature has been concerned with studying how to best learn policies that are simultaneously safety-aware and performant.

In this paper, we demonstrate that the HJ safety value can be learned directly on vision context, thereby expanding HJ reachability to applications where dynamics models may not be available.

### Simulation environment (Description from public repo: https://github.com/learn-to-race/l2r)

<div align="center">
  <br>
  <img src='./assets/images/l2r_framework_figure.png' alt='An overview of the Learn-to-Race framework'/ width=80%>
  <p style="padding: 20px 20px 20px 20px;"><i>An overview of the Learn-to-Race framework</i></p>
  <br>
</div>

Learn-to-Race is an [OpenAI gym](https://gym.openai.com/) compliant, multimodal control environment where agents learn how to race. Unlike many simplistic learning environments, ours is built around Arrival’s high-fidelity racing simulator featuring full software-in-the-loop (SIL), and even hardware-in-the-loop (HIL), simulation capabilities. This simulator has played a key role in bringing autonomous racing technology to real life in the [Roborace series](https://roborace.com/), the world’s first extreme competition of teams developing self-driving AI.

See the Learn-to-Race [official docs](http://learn-to-race.com/) for a comprehensive guide on getting started with their environment.

### Installation requirements

**Python:** We use Learn-to-Race with Python 3.6 or 3.7.

**Graphics Hardware:** The racing simulator runs in a container, but it requires a GPU with Nvidia drivers installed. An Nvidia 970 GTX graphics card is minimally sufficient to simply run the simulator.

**Docker:** The racing simulator runs in a [Docker](https://www.docker.com/get-started) container.

**Container GPU Access:** The container needs access to the GPU, so [nvidia-container-runtime](https://github.com/NVIDIA/nvidia-container-runtime) is also required.

### Quick setup instructions

1. Request access to the Learn-to-Race simulator: see the environment's [official docs](http://learn-to-race.com/).
2. Generate the safety sets:
```bash
cd code/tasks/generate_safety_sets/
python generate_set.py
```
3. Load the simulator docker image: 
```bash
$ docker load < arrival-sim-image.tar.gz
```
4. Start the simulator, e.g., in a seperate terminal window. We recommend using `tmux`.
```bash
docker run -it --rm --user=ubuntu --gpus all --name racing-simulator --net=host --entrypoint="./ArrivalSim.sh" arrival-sim:latest
```
5. Download the source code from this repository and install the package requirements.
```bash
(base) $ conda create -n spar -m python=3.6
(base) $ conda activate spar
(spar) $ pip install -r code/tasks/benchmark_l2r/requirements.txt
```
6. Run SPAR:
```bash
(spar) $ cd code/tasks/benchmark_l2r/
(spar) $ ./run.bash -b spar -m 3.0 -r local
```
7. Replicate toy experiments, to analyse convergence properties
```bash
cd code/tasks/solve_toy_problems/
./run_exp.sh      #Double integrator experiment
```
```bash
cd code/tasks/solve_toy_problems/
./run_exp2.sh     #Dubin's car experiment
```
