def get_torchbiggraph_config():
    config = dict(
        # I/O data
        entity_path="baselines/PBG/data/yago4_with_full_ontology",
        edge_paths=[
            "baselines/PBG/data/yago4_with_full_ontology/yago4_with_full_ontology-train_partitioned",
            "baselines/PBG/data/yago4_with_full_ontology/yago4_with_full_ontology-val_partitioned",
            "baselines/PBG/data/yago4_with_full_ontology/yago4_with_full_ontology-test_partitioned",
        ],
        checkpoint_path="baselines/PBG/model/yago4_with_full_ontology",
        # Graph structure
        entities={
            "all": {"num_partitions": 1},  # unpartitioned
        },
        relations=[
            {
                "name": "all_edges",
                "lhs": "all",
                "rhs": "all",
                "operator": "diagonal",
            }
        ],
        dynamic_relations=True,
        # Scoring model
        dimension=100,
        global_emb=False,
        comparator="dot",
        # Training
        num_epochs=40,
        num_edge_chunks=10,
        batch_size=10000,
        num_batch_negs=500,
        num_uniform_negs=500,
        loss_fn="softmax",
        lr=0.1,
        relation_lr=0.01,
        workers=20,
        # Evaluation during training
        eval_fraction=0,
        # Misc
        verbose=1,
    )

    return config
