import numpy as np

from SEPAL import SEPAL_DIR
from SEPAL.utils import create_graph, create_train_graph
from SEPAL.core_extraction import degree_extraction


if __name__ == "__main__":
    datasets = [
        # "mini_yago3_lcc",
        # "yago3_lcc",
        # "yago4_lcc",
        # "yago4.5_lcc",
        # "yago4_with_full_ontology",
        # "yago4.5_with_full_ontology",
        "full_freebase_lcc",
    ]

    core_prop = {
        "mini_yago3_lcc": 0.2,
        "yago3_lcc": 0.1,
        "yago4_lcc": 0.03,
        "yago4.5_lcc": 0.03,
        "yago4_with_full_ontology": 0.02,
        "yago4.5_with_full_ontology": 0.03,
        "full_freebase_lcc": 0.02,
    }

    for subset in ["train"]:
        for data in datasets:
            print(f"---------------- {data} ----------------")
            print(f"---------------- {subset} ----------------")

            # Load Knowledge Graph
            if subset == "train":
                graph = create_train_graph(data, True)
            else:
                graph = create_graph(data, True)

            # Compute core entities
            core_entities = degree_extraction(core_prop[data], graph)

            # Save core entities
            results_file = (
                SEPAL_DIR / f"core_entities/{data}_{subset}_core_entities.npy"
            )
            np.save(results_file, core_entities)
            print("OK")
