from pathlib import Path

SEPAL_DIR = Path(__file__).absolute().parent

TARGETS = {
    "datasets/evaluation/us_elections/target_log.parquet": "US elections",
    "datasets/evaluation/housing_prices/target_log.parquet": "Housing prices",
    "datasets/evaluation/us_accidents/target_log.parquet": "US accidents",
    "datasets/evaluation/movie_revenues/target_log.parquet": "Movie revenues",
    # "datasets/evaluation/company_employees/target_log.parquet": "Company employees",
}

VALIDATION_FILES = [
    # Classification
    "73376_HISTORICAL_FIGURES",
    "9510_CreativeCommonsAuthors",
    # Regression
    "62826_HISTORICAL_FIGURES",
    "66610_geopolitical_regions",
]

DATASETS_NAMES = {
    "mini_yago3_lcc": "Mini YAGO3",
    "yago3_lcc": "YAGO3",
    "yago4_lcc": "YAGO4",
    "yago4.5_lcc": "YAGO4.5",
    "yago4_with_full_ontology": "YAGO4 + taxonomy",
    "yago4.5_with_full_ontology": "YAGO4.5 + taxonomy",
    "full_freebase_lcc": "Freebase",
    "wikikg90mv2_lcc": "WikiKG90Mv2",
}

MODEL_NAMES = {
    "transe": "TransE",
    "distmult": "DistMult",
    "rotate": "RotatE",
    "mure": "MuRE",
    "tucker": "TuckER",
    "hole": "HolE",
    "nodepiece": "NodePiece",
    "pbg_precomputed": "PBG",
}
