# Implicit Causal Representation Learning via Switchable Mechanisms

We propose ICRL-SM to address the identifiability of implicit latent causal models through soft interventions. 
Previously, implicit models have been introduced with hard interventions which restricts their application. Soft interventions on the other hand, are more
general and are usually observed in real-world applications. 

ICRL-SM improves the identifiability of via causal mechanisms switch variable to better model the effect of soft interventions.

--- 

## Overview of the model

We learn the switch variable V, post-intervention exogenous variables, and pre-intervention exogenous variables from interventional data in a Variational AutoEncoder framework. 

<img src="images/soft_ilcm_arc.jpg" height="300"/>

--- 

### Requirements

```
pip install --upgrade pip
pip install -r requirements.txt

```

---

---

### Dataset

* Epic-Kitchens dataset can be downloaded from [here](https://epic-kitchens.github.io/2023). In order to extract a subset of this dataset you can run this script:
```
bash scripts/run_extract_images.sh
```

* ProcTHOR dataset can be downloaded from [here](https://zenodo.org/record/7813658). 
* Synthetic dataset are generated using the bash script when training the model. 

--- 

### Training

To train each model on a dataset just run its corresponding bash file located in `/scripts/`. For example,
to train ICRL-SM on the synthetic dataset run this bash file:
```
bash scripts/run_icrl_synthetic.sh
```

Pretrained models on `syntheic` dataset with dimension 4 and different seeds are
already saved `/experiments/synthetic/`. Change the "nature_seed" in the scripts for different seeds and do the Test. 

---

### Test

After training is done, uncomment the test section in the same training bash file, specify the path to weights with "ckpt" argument, and run it:
```
bash scripts/run_test_synthetic.sh
```

The results should be saved in the path containing the wights inside the `test` folder.

--- 
