#!/usr/bin/env bash

# Latent and input dim
model_name=elcm
des=
DESCRIPTION="--description=$des"
nature_seed=1

#MODEL="--encoder=resnet50 --select_causal_variable --hidden_units_classifier=64 --hidden_layers_classifier=2 --architecture=mlp --scm=mlp --model=$model_name --scm_adjacency_matrix=fixed_order --resolution=64"
MODEL="--encoder=resnet50 --select_causal_variable --hidden_units_classifier=2 --hidden_layers_classifier=3 --architecture=conv --scm=mlp --model=$model_name
 --scm_adjacency_matrix=enco --resolution=64 --decoder_fix_std --decoder_min_std=1.0"

# Training epochs and settings
TRAINING="--epochs=2000 --pretrain_epochs=10 --model_interventions_after_epoch=30 --batch_size=64 --num_workers=8 --seed=2022"

# Setting for e_norm regularizer
Z_REGULARIZE="--z_regularization_schedule=constant_linear_constant --z_regularization_schedule_initial=0.1 --z_regularization_schedule_final=0.0
              --z_regularization_schedule_initial_constant_epochs=10 --z_regularization_schedule_decay_epochs=10"

# Settings for consistency_mse regularizer
C_REGULARIZE="--consistency_regularization_schedule=constant --consistency_regularization_schedule_initial=0.05 --consistency_regularization_schedule_final=0.05
              --consistency_regularization_schedule_initial_constant_epochs=0 --consistency_regularization_schedule_decay_epochs=0"


LR_SCHEDULE="--lr_schedule=cosine --lr=0.0001 --lr_schedule_minimal=1e-8 --lr_schedule_increase_period_by_factor=1 --lr_schedule_restart_every_epochs=30
              --lr_schedule_step_every_epochs=0 --lr_schedule_step_gamma=0.1"

NUM_TRAINERS=2 # number of gpus

cd ..

# TRAIN
DATADIR="--path_data=../data/causaltriplet-thor/ --dataset=procthor --num_actions=7 --num_objects=23 --nature_seed=$nature_seed"
EXPDIR="--expdir=./experiments/procthor/$model_name"
python main.py $DATADIR $DESCRIPTION $EXPDIR $LR_SCHEDULE $MODEL $TRAINING $Z_REGULARIZE $C_REGULARIZE --dim_x=3 --dim_z=7

# TEST
#DATADIR="--path_data=../data/causaltriplet-thor/ --dataset=procthor --nature_seed=$nature_seed --num_actions=7 --num_objects=23"
#EXPDIR="--expdir=./experiments/Causaltriplet/procthor/$model_name"
#python test.py $DATADIR $EXPDIR $MODEL $TRAINING $Z_REGULARIZE $C_REGULARIZE $LR_SCHEDULE --dim_x=3 --dim_z=7 --ckpt=path

