#!/usr/bin/env bash

# Latent and input dim
dim=4
int_type=soft
int_set=atomic
model_name=ilcm
des=
mean_gaussian=3.0
nature_mode=random # full, random
DESCRIPTION="--description=$des"
nature_seed=5 # 1, 2, 5, 6, 7, 8, 9, 10, 11, 12

#Model settings
MODEL="--encoder=mlp --architecture=mlp --scm=mlp --model=$model_name --scm_adjacency_matrix=none"

# Optimizer settings
OPTIMIZER="--clip_grad_norm=10.0 "

# Training epochs and settings
TRAINING="--epochs=90 --pretrain_epochs=10 --model_interventions_after_epoch=30 --batch_size=64 --num_workers=8 --seed=4901"

# Setting for e_norm regularizer
Z_REGULARIZE="--z_regularization_schedule=constant_linear_constant --z_regularization_schedule_initial=0.01 --z_regularization_schedule_final=0.0
              --z_regularization_schedule_initial_constant_epochs=10 --z_regularization_schedule_decay_epochs=10"

# Settings for consistency_mse regularizer
C_REGULARIZE="--consistency_regularization_schedule=constant --consistency_regularization_schedule_initial=0.01 --consistency_regularization_schedule_final=0.01
              --consistency_regularization_schedule_initial_constant_epochs=0 --consistency_regularization_schedule_decay_epochs=0"

LR_SCHEDULE="--lr_schedule=cosine --lr=3e-4 --lr_schedule_minimal=1e-8 --lr_schedule_increase_period_by_factor=1 --lr_schedule_restart_every_epochs=30
              --lr_schedule_step_every_epochs=0 --lr_schedule_step_gamma=0.1"

cd ..

# TRAIN
#DATADIR="--path_data=../data/synthetic/$dim/$int_set/$int_type/${nature_seed} --dataset=synthetic --nature_mode=$nature_mode
#--intervention_set=$int_set --intervention_type=$int_type --nature_seed=$nature_seed --mean_gaussian=$mean_gaussian"
#EXPDIR="--expdir=./experiments/synthetic/$dim/$int_type/$nature_seed/$model_name"
#python main.py  $DESCRIPTION $TRAINING $OPTIMIZER $Z_REGULARIZE $C_REGULARIZE $DATADIR $EXPDIR $MODEL $LR_SCHEDULE --dim_x=$dim --dim_z=$dim

# TEST
DATADIR="--path_data=../data/synthetic/$dim/$int_set/$int_type/${nature_seed} --dataset=synthetic --nature_mode=$nature_mode
--intervention_set=$int_set --intervention_type=$int_type --nature_seed=$nature_seed --mean_gaussian=$mean_gaussian"
EXPDIR="--expdir=./experiments/synthetic/$int_type/$nature_seed/$model_name"
python test.py $DESCRIPTION $DATADIR $MODEL $OPTIMIZER $TRAINING $Z_REGULARIZE $C_REGULARIZE $LR_SCHEDULE --dim_x=$dim --dim_z=$dim \
 --ckpt=./experiments/synthetic/$dim/$int_type/$nature_seed/$model_name/mlp_90_4901_20240505_022648/weights/best_model.pt

