#!/bin/bash

source ./venv/bin/activate
cd ..

DATADIR=
TEMPDIR=
nature_seed=1
select_actions=20

for p_id in $(seq -f "%02g" 1 37)
do
  prefix="P${p_id}"
  for vid_id in $(seq -f "%02g" 1 50)
  do
    combined_string="${prefix}_${vid_id}"
    tar -xf $DATADIR/$prefix/rgb_frames/$combined_string.tar -C $TEMPDIR
    if [ $? -eq 0 ]; then
      echo $combined_string
      DATA="--path_data=$DATADIR --temp_dir=$TEMPDIR --p_video_id=$combined_string --nature_seed=$nature_seed --select_actions=$select_actions"
      python extract_epickitchens.py $DATA
    else
      echo "Command failed"
    fi
  done

  for vid_id in $(seq 100 140)
  do
    combined_string="${prefix}_${vid_id}"
    tar -xf $DATADIR/$prefix/rgb_frames/$combined_string.tar -C $TEMPDIR
    if [ $? -eq 0 ]; then
      echo $combined_string
      DATA="--path_data=$DATADIR --temp_dir=$TEMPDIR --p_video_id=$combined_string --nature_seed=$nature_seed --select_actions=$select_actions"
      python extract_epickitchens.py $DATA
    else
      echo "Command failed"
    fi
  done
done

rm -r $TEMPDIR

