import ast
import os
import os.path as osp
import sys

proj_path = osp.abspath(osp.dirname(__file__)).split('src')[0]
sys.path.append(proj_path + 'src')
os.chdir(proj_path)

from tune.GraphHD import model_settings
from utils import *
from utils.util_funcs import *


def migrate(dataset, train_percentage, model_name, default_config):
    model_res_path = f'{RES_PATH}{model_name}/{dataset}/l{train_percentage:02d}'

    try:
        f_list = os.listdir(model_res_path)
        res_cnt = len(f_list)
    except FileNotFoundError:
        print(f'No files in {model_res_path}, skipped!!')
        return
    migrate_cnt, rm_cnt = 0, 0
    for f_name in f_list:
        old_f_name = f'{model_res_path}/{f_name}'
        # ! Change settings
        # Find old file end
        with open(old_f_name, 'r') as f:
            res_lines = f.readlines()
            file_content = ''.join(res_lines)
            # Check if trial is completed
            if ('avg_' not in file_content) or '\'nan\'' in file_content:
                os.remove(old_f_name)
                rm_cnt += 1
                continue
            else:
                changed = False
                for i, line in enumerate(res_lines):
                    if line[0] == '{':
                        d = ast.literal_eval(line.strip('\n'))
                        if 'model' in d.keys():  # parameters
                            # Insert unexisting configs to existing config dict
                            missing_configs = {k: v for k, v in default_config.items() if k not in d}
                            try:
                                new_f_name = model_settings['model_config'](SimpleObject({**d, **missing_configs})).res_file
                                if len(missing_configs) > 0:
                                    res_lines[i] = f'{line.split("}")[0]}, {str(missing_configs)[1:]}\n'
                                    changed = True
                            except:
                                pass
                if changed or new_f_name != old_f_name:
                    # Remove old file and content to new file
                    os.remove(old_f_name)
                    with open(new_f_name, 'w') as f:
                        f.write(''.join(res_lines))
                    migrate_cnt +=1

    print(f'{dataset}: {res_cnt} result files, {rm_cnt} removed, {migrate_cnt} migrated.')
    return


if __name__ == "__main__":
    split_list = ['scaffold_80']
    default_cf = {
        'n_samples': 1,
        'cr_weight': 0,
        'cr_temperature': 0,  # Cora 0.5, Citeseer 0.3, Pubmed 0.2
        'bias_mode': 'h0_l1',  # layer specfic, head shared
        'centrality_encoding': False,  # layer specfic, head shared
        'global_nodes': 0
    }

    model = model_settings['model']
    old_setting = f'_GT-'
    new_setting = f'_CR{default_cf["n_samples"]}w{default_cf["cr_weight"]}-Temp{default_cf["cr_temperature"]}_GT-'
    datasets = ['cora', 'citeseer', 'blogcatalog']
    for dataset in datasets:
        for split in split_list:
            migrate(dataset, split, model, default_cf)