import os
import sys

sys.path.append((os.path.abspath(os.path.dirname(__file__)).split('src')[0] + 'src'))

from utils.exp_utils.tuner import Tuner, res_to_excel
from utils import *
from utils.util_funcs import *
from copy import deepcopy
import importlib
import argparse


def get_tuner(model_settings=None, dataset=None, split='scaffold_80', EXP_DICT=None, exp_name=None):
    trial_dict = deepcopy(model_settings)
    trial_dict.update(
        {'dataset': dataset, 'exp_name': exp_name,
         'split': split})
    default_dict = DEFAULT_PARA_DICT[dataset] if dataset in DEFAULT_PARA_DICT else None

    return Tuner(Dict2Config(trial_dict), search_dict=EXP_DICT[exp_name],
                 default_dict=default_dict)


def summarize_results(model_settings, datasets,
                      exp_list, split_list, important_paras, EXP_DICT):
    print(f'Summarizing {datasets}:')
    for dataset in datasets:
        try:
            summarize_by_folder(dataset, model_settings['model'], important_paras)
        except:
            pass
    print(f'\nSummarizing experiments:')
    for dataset in datasets:
        for exp_name in exp_list:
            for split in split_list:
                get_tuner(model_settings, dataset, split, EXP_DICT, exp_name).summarize()


def summarize_by_folder(dataset, model, interested_conf_list):
    '''
    Summarize model results
    '''
    model_res_path = f'{RES_PATH}{model}/{dataset}/'
    # print(f'Summarizing folder: {model_res_path}')
    try:
        split_list = os.listdir(model_res_path)
        # print(f_list)
    except FileNotFoundError:
        # print(f'No such folder, skipped!!')
        return
    for split in split_list:
        # print(f'Summarizing expriment{train_percentage}')
        res_path = f'{model_res_path}{split}/'
        out_prefix = f'{model_res_path.replace(RES_PATH, SUM_PATH)}{model}_{dataset}<{split}>AllRes_'
        mkdir_list([out_prefix])
        res_f_list = [f'{res_path}{f}' for f in os.listdir(res_path)]
        try:
            res_file = res_to_excel(res_f_list, out_prefix, interested_conf_list)
            print(f'Summary of {res_path} finished. Results saved to {res_file}')
        except:
            print(f'Cannot summarize {res_path}, skipped!')
            print(f'f_list:{os.listdir(res_path)}\n{res_path}')


if __name__ == "__main__":
    parser = argparse.ArgumentParser()
    parser.add_argument('-m', '--module', type=str, default='GraphHD', help='Module (model name) to summarize.')
    args = parser.parse_args()
    md = importlib.import_module(f'tune.{args.module}')

    summarize_results(
        model_settings=md.model_settings,
        datasets=md.datasets,
        exp_list=md.EXP_DICT.keys(),
        split_list=md.splits,
        important_paras=md.important_paras,
        EXP_DICT=md.EXP_DICT)
