# CIFAR2 experiment

## Step-by-step guide

1. Train 50 models with 2500 samples randomly picked from 5000 samples in cifar-2. 

TODO: make saving dir more flexible, currently it's fixed to `./checkpoint`.

```bash
mkdir checkpoint
```

```bash
# --array=0-49
python3 model_train.py --training_seed ${SLURM_ARRAY_TASK_ID} --model resnet9
python3 model_train.py --training_seed ${SLURM_ARRAY_TASK_ID} --model mlp
```

Two files will be saved for the training, `selected_indices_[...].txt` for the data index used for this model and `checkpoint_[...].pt` for the last epoch's checkpoint.

2. Get the golden standard model output function
   
   ```bash
   python3 get_gold_standard.py --model resnet9
   python3 get_gold_standard.py --model mlp
   ```
   
   This will save `model_output_checkpoint_[...].pt`.

3. Get the attribution score.

TODO: make the score saving dir more flexible, currently it's fixed to `./score`.

TODO: make the two stage sampling method can be activated in script rather than code changing.

```bash
mkdir score
```

```bash
python3 main.py --ensemble 1 --independent 1
python3 main.py --ensemble 10 --independent 1 --dropout --model resnet9
python3 main.py --ensemble 10 --independent 1 --dropout --model mlp
python3 main.py --ensemble 10 --independent 1 --dropout_only_Q --model resnet9
python3 main.py --ensemble 10 --independent 1 --dropout_only_Q --model mlp
```

4. Get the spearman ranking correlation.

TODO: some paths still needs to be changed in `spearman.py`.

```bash
python spearman.py
```
