import torch.nn as nn
import torch.nn.functional as F
import torch


class ConvNet(nn.Module):
    def __init__(self, dropout_rate=0.5):
        super().__init__()
        # self.conv1 = nn.Conv2d(3, 6, 5)
        # self.pool = nn.MaxPool2d(2, 2)
        # self.conv2 = nn.Conv2d(6, 16, 5)
        # self.fc1 = nn.Linear(16 * 5 * 5, 120)
        self.fc1 = nn.Linear(32*32*3, 120)
        self.dropout_1 = nn.Dropout(dropout_rate)
        self.fc2 = nn.Linear(120, 84)
        self.dropout_2 = nn.Dropout(dropout_rate)
        self.fc3 = nn.Linear(84, 2)

    def forward(self, x):
        # x = self.pool(F.relu(self.conv1(x)))
        # x = self.pool(F.relu(self.conv2(x)))
        x = torch.flatten(x, 1) # flatten all dimensions except batch
        x = F.relu(self.fc1(x))
        x = self.dropout_1(x)
        x = F.relu(self.fc2(x))
        x = self.dropout_2(x)
        x = self.fc3(x)
        return x

    def enable_dropout(self):
        """Function to enable the dropout layers during test-time """
        for module in self.modules():
            if module.__class__.__name__.startswith('Dropout'):
                module.train()

    def disable_dropout(self):
        """Function to enable the dropout layers during test-time """
        for module in self.modules():
            if module.__class__.__name__.startswith('Dropout'):
                module.eval()
