total_time = 1024;
d_range = [2 : 4];
error_probs1 = zeros(length(d_range), 1);
stats = zeros(length(d_range), 5);
for ii = 1 : length(d_range)
    d = d_range(ii);
    error_prob1 = zeros(total_time, 1);
    stat = zeros(total_time, 5);
    parfor jj = 1 : total_time
        K = 3 ^ d;
        T = 2 * K;
        [theta, A] = sphere_data_generator(d, K);
        [delta_min, H1lin, H1, H2lin, H2] = data_stat(theta, A);
        stat(jj, :) = [delta_min, H1lin, H1, H2lin, H2];
        [~ , I] = max(theta' * A);
        best_arm = Peace(theta, A, T);
        if I ~= best_arm
            error_prob1(jj) = 1;
        end
        [jj, d]
    end
    error_probs1(ii, :) = sum([error_prob1]) / total_time;
    stats(ii, :) = mean(stat);
end

figure;
bar(d_range, error_probs1);
xlabel('d');
ylabel('Error probability');
legend({'methond'}, 'Location', 'southeastoutside');
ylim([0 1]);

save('c=3_P.mat','d_range', 'error_probs1', 'stats')
