function best_arm = Sequential_Halving(theta, A, T)
%SEQUENTIAL_HALVING Summary of this function goes here
%   Detailed explanation goes here
if size(theta, 1) ~= 1
    theta = theta';
end
K = size(A, 2);
index_r = 1 : K;
mu = theta * A;
for r = 1 : ceil(log2(K))
    mu_r = zeros(size(index_r));
    for ii = 1 : length(index_r)
        mu_r(ii) = mu(index_r(ii)) + randn / sqrt(floor(T / length(index_r) / ceil(log2(K))));
    end
    [~, I] = maxk(mu_r, ceil(length(index_r) / 2));
    index_r = index_r(I);
end
best_arm =  index_r;
end