total_time = 1024;
T = 25;
K_range = round(linspace(3, (T-1),11));
error_probs1 = zeros(length(K_range), 7);
for ii = 1 : length(K_range)
    K = K_range(ii);
    error_prob1 = zeros(total_time, 1);
    error_prob2 = zeros(total_time, 1);
    error_prob3 = zeros(total_time, 1);
    error_prob4 = zeros(total_time, 1);
    error_prob5 = zeros(total_time, 1);
    error_prob6 = zeros(total_time, 1);
    error_prob7 = zeros(total_time, 1);
    parfor jj = 1 : total_time
        %[theta, A] = usual_data_generator(d);
        %[theta, A] = sphere_data_generator(d, K);
        rng((K - 1) * total_time + jj);
        [theta, A] = many_sub_data_generator(K);
        [~ , I] = max(theta' * A);
        best_arm = myalgo(theta, A, T);
        if I ~= best_arm
            error_prob1(jj) = 1;
        end
        best_arm = Sequential_Halving(theta, A, T);
        if I ~= best_arm
            error_prob2(jj) = 1;
        end
        best_arm = BayesGap_Oracle(theta, A, T);
        if I ~= best_arm
            error_prob3(jj) = 1;
        end
        best_arm = BayesGap_Adaptive(theta, A, T);
        if I ~= best_arm
            error_prob4(jj) = 1;
        end
        best_arm = Peace(theta, A, T);
        if I ~= best_arm
            error_prob5(jj) = 1;
        end
        best_arm = LinearExploration(theta, A, T);
        if I ~= best_arm
            error_prob6(jj) = 1;
        end
        best_arm = GSE(theta, A, T);
        if I ~= best_arm
            error_prob7(jj) = 1;
        end
        [jj, K]
    end
    error_probs1(ii, :) = sum([error_prob1, error_prob2, error_prob3, error_prob4, error_prob5, error_prob6, error_prob7]) / total_time;
end

figure;
markers = {'none', '.', '*', 'x', 'o', '+', 's'};
for i = 1 : 7
    plot(K_range, error_probs1(:, i), 'Marker', markers{i});
    hold on;
end
xlabel('K');
ylabel('Error probability');
legend('OD-LinBAI', 'Sequential Halving', 'BayesGap-Oracle', 'BayesGap-Adaptive', 'Peace', 'LinearExploration', 'GSE', 'Location', 'NorthWest');
ylim([0 1]);

%saveas(gcf,'T=25.epsc');
%save('T=25.mat','K_range', 'error_probs1');
