function [theta, A] = sphere_data_generator(d, K)
%SPHERE_DATA_GENERATOR

A = [];
distance_max = -inf;
for ii = 1 : K
    random_vector = randn(d, 1);
    random_vector = random_vector / norm(random_vector, 2);
    if ii > 1
        [distance_max_tmp, I] = max(random_vector' * A);
        if distance_max_tmp > distance_max
            distance_max_a = I;
            distance_max_b = ii;
            distance_max = distance_max_tmp;
        end
    end
    A = [A, random_vector];
end
theta = A(:, distance_max_a) + 0.01 * (A(:, distance_max_b) - A(:, distance_max_a));

% mu = theta' * A;
% gap = max(mu) - mu;
% gap_min = min(gap(gap ~= 0));

end