# Gaussian Ensemble Belief Propagation

experiments from the paper are generated by the notebooks whose names start with `mp_`.

This is academic prototype code. It is not production-ready.
Pull requests welcome.

## Run experiments from the paper

`ipython` or `jupyter` is required to run the notebooks.

```ipython
%run mp_026a_factor_graph_sysid_advection_sanity.py
%run mp_026b_factor_graph_sysid_advection_d.py
%run mp_026c_factor_graph_sysid_advection_n_ens.py
%run mp_030a_factor_graph_sysid_ns2d_sanity.py
%run mp_030b_factor_graph_sysid_ns2d_d.py
%run mp_030c_factor_graph_sysid_ns2d_n_ens.py
%run mp_030d_factor_graph_sysid_ns2d_visc.py
```

## Install dependencies


Now, install the requirements.
Local desktop:

```bash
python3 -m venv --prompt probop ./venv
source ./venv/bin/activate  # linux or macos, bash-like
pip install -r requirements.txt
python -m ipykernel install --user --name=probop  # for jupyter
```

## Further reading

* Joe Ortiz’ GaBP implementations

  * [Gaussian Belief Propagation Library](https://colab.research.google.com/drive/1-nrE95X4UC9FBLR0-cTnsIP_XhA_PZKW?usp=sharing) in torch

## Useful commands

Delete old logs

24 hours ago:
```bash
find ./_logs -type f -mtime +1 -exec rm {} \;
```

12 hours ago
```bash
find ./_logs
 -type f -mmin +720 -exec rm {} \;
```
