set -x

export HYDRA_FULL_ERROR=1
# export CUDA_VISIBLE_DEVICES=0,1,2,3

PROJECT_NAME=fortune

## task config
# TASK=formula
TASK=text

# dataset config
DATASET=wikitq
# DATASET=tabfact
# DATASET=finqa
# DATASET=hitab
# DATASET=multihiertt
# DATASET=aitqa
# DATASET=tablebench


# model config
MODEL=qwen
# MODEL=llama
# MODEL=qwen14b


EXP_NAME=sft_${TASK}_${MODEL}_${DATASET}
OUTPUT_DIR=training_outputs/sft/${PROJECT_NAME}/${EXP_NAME}


if [ $MODEL = 'qwen' ]; then
    INIT_MODEL=Qwen/Qwen2.5-Coder-7B-Instruct
elif [ $MODEL = 'llama' ]; then
    INIT_MODEL=meta-llama/Llama-3.1-8B-Instruct
elif [ $MODEL = 'qwen14b' ]; then
    INIT_MODEL=Qwen/Qwen2.5-Coder-14B-Instruct
    MODEL=qwen
fi


# training config
NODE_NUM=1
GPU_NUM=4
MICRO_BATCH_SIZE_PER_GPU=1


train_files=data/processed_data/${TASK}/${MODEL}/${DATASET}/sft.parquet
test_files=data/processed_data/${TASK}/${MODEL}/${DATASET}/sft.parquet



torchrun --standalone --nnodes=$NODE_NUM --nproc_per_node=$GPU_NUM \
     -m verl.trainer.fsdp_sft_trainer \
    data.train_files=$train_files \
    data.val_files=$test_files \
    data.train_batch_size=128 \
    data.micro_batch_size_per_gpu=$MICRO_BATCH_SIZE_PER_GPU \
    optim.lr=2e-5 \
    data.prompt_key=prompt \
    data.response_key=extra_info \
    +data.prompt_dict_keys=null \
    +data.response_dict_keys=['sft_response'] \
    data.max_length=10752 \
    data.truncation=error \
    model.partial_pretrain=$INIT_MODEL \
    trainer.default_local_dir=$OUTPUT_DIR \
    trainer.project_name=$PROJECT_NAME \
    trainer.experiment_name=$EXP_NAME \
    trainer.logger=['console, wandb'] \
    trainer.total_epochs=3 \
    trainer.default_hdfs_dir=null \
    ulysses_sequence_parallel_size=2 \
    use_remove_padding=true
