import os

from azure.identity import ManagedIdentityCredential, get_bearer_token_provider
from openai import AzureOpenAI, OpenAI


# Azure OpenAI API
if os.path.exists('azure_openai_api.key'):
    with open('azure_openai_api.key', 'r') as f:
        client_id = f.readline().strip()
        provider_url = f.readline().strip()
        azure_endpoint = f.readline().strip()

    token_provider = get_bearer_token_provider(
        ManagedIdentityCredential(client_id=client_id), provider_url
    )

    client = AzureOpenAI(
        api_version="2025-03-01-preview",
        azure_endpoint=azure_endpoint,
        azure_ad_token_provider=token_provider
    )
# OpenAI API
elif os.path.exists('openai_api.key'):
    with open('openai_api.key', 'r') as f:
        api_key = f.readline().strip()
    client = OpenAI(
        api_key=api_key,
    )
else:
    raise ValueError("No API key found")


def get_openai_llm_response(prompt, model='gpt-4o', json_output=False, json_schema=None, temperature=0):
    if model == 'gpt-4o':
        model = 'gpt-4o' # gpt-4o-2024-11-20
    elif model == 'gpt-3.5-turbo':
        model = 'gpt-35-turbo' # gpt-3.5-turbo-0125
    elif model == 'gpt-4o-mini':
        model = 'gpt-4o-mini' # gpt-4o-mini-2024-07-18

    if json_output and json_schema:
        response = client.chat.completions.create(
            model=model,
            messages=[{"role": "user", "content": prompt}],
            response_format={
                "type": "json_schema",
                "json_schema": {
                    "name": json_schema["title"],
                    "description": json_schema.pop("description", ""),
                    "schema": json_schema,
                    "strict": True
                }
            },
            temperature=temperature
        ).choices[0].message.content
    else:
        response = client.chat.completions.create(
            model=model,
            messages=[{"role": "user", "content": prompt}],
            response_format={"type": "json_object" if json_output else "text"},
            temperature=temperature
        ).choices[0].message.content

    return response


def get_openai_lrm_response(prompt, model='o1'):
    if model == 'o1':
        model = 'o1' # o1-2024-12-17
    elif model == 'o1-mini':
        model = 'o1-mini' # o1-2024-9-12

    response = client.chat.completions.create(
        model=model,
        messages=[
            {"role": "user", "content": prompt}
        ],
    ).choices[0].message.content

    return response



if __name__ == '__main__':
    # prompt = "What is the capital of France?"
    # prompt = "What is the capital of France? step by step"
    prompt = "667x226+31=?"
    print(get_openai_llm_response(prompt, model='gpt-4o'))