## launch vllm server
# vllm serve hf_models/Qwen/Qwen2.5-3B-Instruct
# vllm serve hf_models/Qwen/Qwen2.5-7B-Instruct


from openai import OpenAI


model = 'hf_models/Qwen/Qwen2.5-7B-Instruct'

prompt = """
<|im_start|>system
You are a helpful assistant. You first think about the reasoning process in the mind and then provides the user with the answer.<|im_end|>
<|im_start|>user
You are an expert in writing Excel formulas. Your task is to generate the correct formula to answer a given question, based on the provided table.

Show your reasoning within <think> </think> tags. Your final output must be in JSON format, enclosed in <answer> </answer> tags. For example:
<think>
[step-by-step reasoning]
</think>
<answer>
{
    "formula": "=......."
}
</answer>

Below are all the formula operators you can use, along with their instructions and examples:

# Formula Operator List
[{'name': 'PLUS', 'symbol': '+', 'description': 'Adds two numbers together', 'example': '=A1 + A2'}, {'name': 'MINUS', 'symbol': '-', 'description': 'Subtracts one number from another', 'example': '=A1 - A2'}, {'name': 'MULTIPLY', 'symbol': '*', 'description': 'Multiplies two numbers together', 'example': '=A1 * A2'}, {'name': 'DIVIDE', 'symbol': '/', 'description': 'Divides one number by another', 'example': '=A1 / A2'}, {'name': 'SUM', 'symbol': 'SUM', 'description': 'Sums a range of numbers', 'example': '=SUM(A1:A10)'}, {'name': 'AVERAGE', 'symbol': 'AVERAGE', 'description': 'Calculates the average of a range of numbers', 'example': '=AVERAGE(A1:A10)'}, {'name': 'COUNT', 'symbol': 'COUNT', 'description': 'Counts the number of numbers in a range', 'example': '=COUNT(A1:A10)'}, {'name': 'MAX', 'symbol': 'MAX', 'description': 'Finds the maximum number in a range', 'example': '=MAX(A1:A10)'}, {'name': 'MIN', 'symbol': 'MIN', 'description': 'Finds the minimum number in a range', 'example': '=MIN(A1:A10)'}, {'name': 'EQUAL', 'symbol': '=', 'description': 'Returns TRUE if the two values are equal', 'example': '=A1 = A2'}, {'name': 'NOT_EQUAL', 'symbol': '<>', 'description': 'Returns TRUE if the two values are not equal', 'example': '=A1 <> A2'}, {'name': 'GREATER_THAN', 'symbol': '>', 'description': 'Returns TRUE if the first value is greater than the second value', 'example': '=A1 > A2'}, {'name': 'LESS_THAN', 'symbol': '<', 'description': 'Returns TRUE if the first value is less than the second value', 'example': '=A1 < A2'}, {'name': 'GREATER_THAN_OR_EQUAL', 'symbol': '>=', 'description': 'Returns TRUE if the first value is greater than or equal to the second value', 'example': '=A1 >= A2'}, {'name': 'LESS_THAN_OR_EQUAL', 'symbol': '<=', 'description': 'Returns TRUE if the first value is less than or equal to the second value', 'example': '=A1 <= A2'}, {'name': 'AND', 'symbol': 'AND', 'description': 'Returns TRUE if all arguments are TRUE', 'example': '=AND(A1, A2)'}, {'name': 'OR', 'symbol': 'OR', 'description': 'Returns TRUE if any argument is TRUE', 'example': '=OR(A1, A2)'}, {'name': 'NOT', 'symbol': 'NOT', 'description': 'Returns TRUE if the argument is FALSE', 'example': '=NOT(A1)'}, {'name': 'IF', 'symbol': 'IF', 'description': 'Returns one value if a condition is TRUE and another value if it is FALSE', 'example': '=IF(A1 > 10, "Yes", "No")'}, {'name': 'TRUE', 'symbol': 'TRUE', 'description': 'Returns TRUE', 'example': '=TRUE'}, {'name': 'FALSE', 'symbol': 'FALSE', 'description': 'Returns FALSE', 'example': '=FALSE'}, {'name': 'CONCAT', 'symbol': 'CONCAT', 'description': 'Concatenates answers together for a multiple answer question', 'example': '=CONCAT(A1, A2)'}]


The table is represented as cell-value pairs, where each pair consists of a cell address and its content, separated by a comma (e.g., 'A1,Year').
Multiple cells are separated by a pipe symbol '|' (e.g., 'A1,Year|A2,Profit').
Empty cell of A1 can be represented as 'A1,|A2,Profit'.

Here is the table:
|A1,proximal determinants - physical environments and resources|B1,at least one chronic condition|C1,fair or poor self-rated general health|D1,fair or poor self-rated mental health|
|A2,less than high school education|B2,0.66|C2,0.26|D2,0.15|
|A3,high school education or higher|B3,0.61|C3,0.21|D3,0.13|
|A4,unemployed|B4,0.61|C4,0.25|D4,0.17|
|A5,employed|B5,0.60|C5,0.15|D5,0.10|
|A6,annual household income in lowest tercile|B6,0.64|C6,0.26|D6,0.16|
|A7,annual household income above lowest tercile|B7,0.62|C7,0.20|D7,0.12|
|A8,food insecure|B8,0.71|C8,0.28|D8,0.19|
|A9,food secure|B9,0.61|C9,0.20|D9,0.12|

Here is the question:
which type of people with at least one chronic condition had a higher proportion?

Show your reasoning within <think> </think> tags. Your final output must be in JSON format, enclosed in <answer> </answer> tags. For example:
<think>
[step-by-step reasoning]
</think>
<answer>
{{
    "formula": "=......."
}}
</answer>

Notes:
1. For simple questions, if a direct cell reference is appropriate, simply return the formula as =CellAddress.
2. Construct the formula using only the provided operator symbols from the formula operator list. Do not use any operators or functions not in that list.
3. Always use cell addresses in the formula—do not reference values directly.
4. Do not use the dollar sign ($) in addresses; use only formats like A1, A2, etc.
5. If there are multiple answers for a question, use the CONCAT function to concatenate them together (do not use the ampersand &).
6. The result of the formula must be the direct final answer to the question.

<|im_end|>
<|im_start|>assistant
Let me write the formula with reasoning.
<think>
"""



openai_api_key = "EMPTY"
openai_api_base = "http://localhost:8000/v1"
client = OpenAI(
    api_key=openai_api_key,
    base_url=openai_api_base,
)
completion = client.completions.create(
    model=model,
    prompt=prompt,
    max_tokens=512,
    temperature=0.6
)

print("Completion result:", completion.choices[0].text)



