import numpy as np
from typing import List, Union


def basic_stats_from_numeric_list(data: List[Union[int, float]]):
    data = np.array(data)
    bin_perc, bin_edges = np.histogram(data, bins=10, density=True)
    stats = {
        "min": np.min(data).item(),
        "max": np.max(data).item(),
        "median": np.median(data).item(),
        "mean": np.mean(data).item(),
        "std": np.std(data).item(),
        "hist": (bin_perc.tolist(), bin_edges.tolist()),
    }

    return stats
