


class MultiLogger:
    def __init__(self, basic_loggers, advanced_loggers) -> None:
        self.basic_loggers = basic_loggers
        self.advanced_loggers = advanced_loggers


    def log_basic(self, text: str):
        for bl in self.basic_loggers:
            bl(text)
    
    def log_advanced(self, text: str, method: str):
        for al in self.advanced_loggers:
            f = getattr(al, method)
            f(text)


    def log_all(self, text, adv_method):
        self.log_basic(text)
        self.log_advanced(text, method=adv_method)
        
            

    def info(self, text: str):
        self.log_all(text, "info")

    def debug(self, text: str):
        self.log_advanced(text, "debug")


    def warning(self, text: str):
        self.log_advanced(text, "warning")
