#！/bin/bash



for iexp in "1_" "2_" "3_"
do	

	python train.py --expid $iexp"r50byoleman2_mlpproxy" --outpath_base './res/' --sampling_strategy "margin" --dataset_name "feas" --totfeas_path './totfeas_byol_eman.npy' --totlabel_path './totlabel.npy' --totfeas_test_path './totfeas_byol_eman_test.npy' --totlabel_test_path './totlabels_test.npy' --al_budget "[10000]*10" --train_eps 50 --lr 0.01 --cls_lr 0.01 --weight_decay 0 --milestone '30,40' --early_stop 50 --batchsize_train 2048 --batchsize_al_forward 16384 --batchsize_evaluation 16384 --training_mode 0 --classifier_type "MLP" --classifier_dim '2048,2048,1000' --selfmodel_path './res50_byol_eman_200ep.pth.tar' 
	
	python lpft_mlpproxy.py --expid $iexp"r50byoleman2_mlpproxy_lpft" --mlpproxy_expid $iexp"r50byoleman2_mlpproxy" --sampling_strategy 'margin' --outpath_base './res/' --dataset_name "imagenet" --dataset_path './imagenet/' --train_eps 50 --lr 0.01 --cls_lr 0.01 --freezelr 0.5 --freeze_eps 5 --ft_eps 45 --milestone '30,40' --early_stop 50 --batchsize_train 128 --batchsize_al_forward 512 --batchsize_evaluation 512 --training_mode 3 --alidx_name "alidx.npy" --classifier_type "Linear" --classifier_dim '2048,2048,1000' --al_budget "[20000]+[10000]*8" --network "res50" --selfmodel_path './res50_byol_eman_200ep.pth.tar'
	
done

