
from Data_Generation import *
from TV_estimation import *


def Case(n,m,seed):
    ## n: sample size, m: dimension
    mu_1, mu_2 = np.zeros(m), np.zeros(m) + np.ones(m) * 0.2
    E = np.random.uniform(-0.05,0.05,[m,m])
    Sigma_1, Sigma_2 = np.identity(m), np.identity(m) + E + E.T
    train_size, test_size = n, 50000
    x_train, y_train = Gaussian_Sample(train_size, mu_1, Sigma_1, mu_2, Sigma_2, sed=seed)
    x_test, y_test = Gaussian_Sample(test_size, mu_1, Sigma_1, mu_2, Sigma_2, sed=i)
    x_real, x_syn = x_train[y_train == 1], x_train[y_train == 0]
    mu_1_bar, mu_2_bar = x_real.mean(axis=0), x_syn.mean(axis=0)
    Sigma_1_bar, Sigma_2_bar = np.cov(x_real, rowvar=False), np.cov(x_syn, rowvar=False)

    True_TV = MC_TV_Baseline(mu_1, Sigma_1, mu_2, Sigma_2)
    DisE = Dist_TV(x_train, x_test, y_train, y_test)
    KDE = KDE_TV(x_real, x_syn)
    EM = KNN(x_real, x_syn)
    NNR = NNRE(x_real, x_syn)
    PE = MC_TV_Baseline(mu_1_bar, Sigma_1_bar, mu_2_bar, Sigma_2_bar)
    return(True_TV,DisE,KDE,EM,NNR,PE)



Error = []

for i in range(20):
    Error.append(Case(10000,5,i))
    print(i)

