#!/bin/bash

export CUDA_VISIBLE_DEVICES="0,1,2,3,4,5,6,7"

python -m torch.distributed.launch \
    --nproc_per_node=8 \
    --master_port=2303 \
    ./main_retrieval.py \
    --do_train=1 \
    --workers=8 \
    --n_display=50 \
    --epochs=5 \
    --lr=1e-4 \
    --coef_lr=1e-3 \
    --batch_size=256 \
    --batch_size_val=256 \
    --agg_module=seqTransf \
    --anno_path=./data/MSR-VTT/anns \
    --video_path=./data/MSR-VTT/videos/all \
    --datatype=msrvtt \
    --base_encoder=ViT-B/32 \
    --max_words=32 \
    --max_frames=12 \
    --video_framerate=1 \
    --output_dir=./output
