import json
from langchain_community.embeddings import HuggingFaceEmbeddings
from langchain_community.vectorstores import FAISS
from collections import Counter
import openai
import os
from openai import OpenAI

def testAndtrain(groundTruth_file):
    with open(groundTruth_file, 'r') as f:
        groundTruth = json.load(f)
    queries_test = []
    tools_test = []

    # Iterate through each item in the JSON data
    test_size = int(len(data) / 5)
    for item in groundTruth[:test_size]:
        queries_test.append(item['query'])
        tools_test.append(item['tool'])

    queries = []
    tools = []
    query_tool_dict = {}

    # Process each item in the JSON data
    for item in data[test_size:]:
        # Extract the content after "query" and remove the surrounding quotes
        query = item["query"].strip(':')
        queries.append(query)

        # Extract the content after "tool" and add the list to tools
        query_tool_list = item["tool"]
        tools.append(query_tool_list)

        # Populate the dictionary
        query_tool_dict[query] = query_tool_list


# Load your JSON data
with open('multi_tool_query_golden.json', 'r') as f:
    data = json.load(f)

with open('big_tool_des.json', 'r') as f:
    data_tool = json.load(f)
# Initialize lists to hold queries and tools

tool_list = []

# Iterate through each item in the JSON data
for key, value in data_tool.items():
    # Combine the key and value into a single string
    combined_string = f"{key}: {value}"
    tool_list.append(combined_string)

queries_test = []
tools_test = []

# Iterate through each item in the JSON data
test_size = int(len(data) / 5)
for item in data[:test_size]:
    queries_test.append(item['query'])
    tools_test.append(item['tool'])


# Example list
items = [
    "What is the current price of Tesla stocks and how does it compare to other electric vehicle companies?->ProductSearch,FinanceTool",
    "What are some recent studies on the impact of technology on the stock market, and how does it affect financial investments?->ResearchHelper,FinanceTool",
    "I'm interested in learning about the correlation between technological advancements and changes in stock market indices. Can you provide me with historical data and analysis regarding this?->ResearchHelper,FinanceTool"
]

def unique_tool(queries, query_to_tools):# Initialize a set to store unique items
    unique_tools = set()

    # Iterate over the queries and add corresponding tools to the set
    for query in queries:
        unique_tools.update(query_to_tools[query])

    # Convert the set back to a list (if required)
    unique_tools_list = list(unique_tools)
    return unique_tools_list




# Initialize lists and dictionary
queries = []
tools = []
query_tool_dict = {}

# Process each item in the JSON data
for item in data[test_size:]:
    # Extract the content after "query" and remove the surrounding quotes
    query = item["query"].strip(':')
    queries.append(query)

    # Extract the content after "tool" and add the list to tools
    tool_list1 = item["tool"]
    tools.append(tool_list1)

    # Populate the dictionary
    query_tool_dict[query] = tool_list1







HuggingFace_embedding = HuggingFaceEmbeddings()  # 向量长度--768

embedding_model = HuggingFace_embedding

vectordb_QueryTool = FAISS.from_texts(texts=queries, embedding=embedding_model)
vectordb_tool = FAISS.from_texts(texts=tool_list, embedding=embedding_model)
query1 = "I want to know the latest news about Tesla and how it has impacted the stock market."
tool1 = "FinanceTool: Stay informed with the latest financial updates, real-time insights, and analysis on a wide range of options, stocks, cryptocurrencies, and more."

simi_search_tool= vectordb_tool.similarity_search(query1, 10)
tool_list2 = [docu.page_content for docu in simi_search_tool]
top_tool = tool_list2[0]
extracted_toolName1 = [item.split(":")[0] for item in tool_list2]
print(extracted_toolName1)

simi_search_QueryTool= vectordb_QueryTool.similarity_search(query1, 10)
Query_list = [docu.page_content for docu in simi_search_QueryTool]
unique = unique_tool(Query_list, query_tool_dict)
print(unique)
simi_search_ToolTool= vectordb_tool.similarity_search(top_tool, 10)
toolTool_list = [docu.page_content for docu in simi_search_ToolTool]
extracted_toolName2 = [item.split(":")[0] for item in toolTool_list]
print(extracted_toolName2)


combined_list = extracted_toolName1 + unique + extracted_toolName2

# Count the frequency of each element
element_counts = Counter(combined_list)

# Sort elements by their frequency (from high to low)
sorted_elements = [item for item, count in element_counts.most_common()]

# Print the result
print(sorted_elements)
#three ranked method


#开始询问
def scoring_by_chatgpt(question, potential_tool_list):
    os.environ["OPENAI_API_KEY"] = "sk-proj-yqfdABXy181oLK5yF1BZT3BlbkFJm9FMBg1aWZ9RkzqRfXNJ"
    openai.api_key = os.environ["OPENAI_API_KEY"]
    client = OpenAI()
    completion = client.chat.completions.create(
        model="gpt-3.5-turbo",
        messages=[
            {"role": "user", "content": "what is your name" }
        ]
    )
    return completion.choices[0].message.content