import json

# Function to process the JSON file and replace "TimeTable Lookup " with "TimeTable Lookup"
def replace_timetable_lookup(json_file, output_file):
    # Load the input JSON file
    with open(json_file, 'r', encoding='utf-8') as file:
        data = json.load(file)
    
    # Iterate through each item in the list
    for item in data:
        # Check if "TimeTable Lookup " exists in the "tool" list
        if "TimeTable Lookup " in item['tool']:
            # Replace it with "TimeTable Lookup"
            item['tool'] = [tool.replace("TimeTable Lookup ", "TimeTable Lookup") for tool in item['tool']]
    
    # Save the updated data to a new JSON file
    with open(output_file, 'w', encoding='utf-8') as outfile:
        json.dump(data, outfile, indent=4)

    print(f"Processing complete. Updated data saved in '{output_file}'.")

# Example usage
replace_timetable_lookup('shuffle_tool_query_ToolLens.json', 'new_shuffle_tool_query_ToolLens.json')

