def TRACCAndAcc(A, B):
    # Convert both lists to sets for intersection operation
    set_A = set(A)
    set_B = set(B)

    # Calculate the intersection of the two sets
    intersection_AB = set_A.intersection(set_B)

    # Calculate n1 (number of elements in A) and n2 (number of elements in B)
    n1 = len(A)
    n2 = len(B)

    # Calculate the original accuracy
    original_accuracy = len(intersection_AB) / n1

    # Calculate the union of the two sets
    union_AB = set_A.union(set_B)

    # Calculate the final modified accuracy based on your formula
    TRACC = (1 - (1 / len(union_AB)) * abs(n2 - n1)) * original_accuracy

    return TRACC, original_accuracy 

# Example usage:
A = ["apple", "banana", "orange", "sss"]
B = ["apple", "orange", "grape"]

TRACC, acc = TRACCAndAcc(A, B)
print(TRACC)
print(acc)
