# Self-supervised Video Representation Learning

## Requirements
> This is the experimental environment. 

- python  3.7.4
- torch 1.10.0+cu102
- torchvision 0.11.0+cu102
- cudatoolkit 10.2.89 (important for faiss-gpu)
- tensorboard
- tensorboardX
- accimage  (official github) 
- faiss-gpu (official github) 
- Pillow = 6.1.0
- opencv
- scipy
- tqdm
- pandas (maybe)


## Dataset Prepration
### Overall
The datasets are arranged as follows, where <base_path> is defined in `config.py`.

Note that all the `split` folders are available at `data/<dataset_name>/`.

```markdown
<base_path>/DataSets/
    |---UCF101/
    |   |---jpegs_256/
    |   |   |---<video1>/
    |   |   |   |---XXX.jpg
    |   |   |   |--- ...
    |   |   |---<video2>/
    |   |   |--- ...
    |   |---split/
    |   |   |---ClassInd.txt
    |   |   |---trainlist01.txt
    |   |   |---testlist01.txt
    |   |   |--- ...
    |
    |---HMDB51/
    |   |---jpegs_256/
    |   |   |   |---<video1>/
    |   |   |   |   |---XXX.jpg
    |   |   |   |   |--- ...
    |   |   |   |---<video2>/
    |   |   |   |--- ...
    |   |---split/
    |   |   |---ClassInd.txt
    |   |   |---trainlist01.txt
    |   |   |---testlist01.txt
    |   |   |--- ...
            
```

### DataSet Download

*Official files:* [UCF101](http://crcv.ucf.edu/data/UCF101.php) 

*Official files:* [HMDB51](http://serre-lab.clps.brown.edu/resource/hmdb-a-large-human-motion-database/).


## Pre-trained Models

> Please download `ckpt.zip` from [This anonymous URL](https://zenodo.org/record/7327830#.Y3UkXuxBwUE). 
> 
> Unzip it. Put the folder `ckpt` into the `code` folder.

## Testing 
> We provide r3d model for video retrieval, and r21d model for action recognition (fine-tuning).

### Video retrieval

```
python train_ssl.py --evaluate --r_batch_size 16 --gpu-id 0  --model_name focus_r3d --resume ckpt.pth
python train_ssl.py --evaluate --eval_dataset hmdb51 --r_batch_size 8 --gpu-id 1  --model_name focus_r3d --resume ckpt.pth
```


### Fine-tuning

```
python ft_classify.py --model r21d  --mode test --dataset ucf101 --test_batch_size 64 --model_name r21d_ft --gpu-id 2
python ft_classify.py --model r21d  --mode test --dataset hmdb51 --test_batch_size 64 --model_name r21d_hmdb51_ft --gpu-id 3
```

